package website.dachuan.migration.dao.sql;

import website.dachuan.migration.mapping.DatabaseId;
import website.dachuan.migration.mapping.DatabaseIdProvider;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;

public class SqlProviderStrategy {
    private static final Map<String, SqlProvider> sqlProviderMap = new HashMap<>();

    static {
        ServiceLoader<SqlProvider> sqlProviderServiceLoader = ServiceLoader.load(SqlProvider.class);
        for (SqlProvider sqlProvider : sqlProviderServiceLoader) {
            for (DatabaseId dbId : sqlProvider.key()) {
                sqlProviderMap.put(dbId.name(), sqlProvider);
            }
        }
    }

    public static SqlProvider getSqlProvider(Connection conn) {
        return sqlProviderMap.get(DatabaseIdProvider.getDatabaseId(conn));
    }
}
