package website.dachuan.migration.dao;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.handlers.MapHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import website.dachuan.migration.entity.SchemaHistoryEntity;
import website.dachuan.migration.mapping.DatabaseIdProvider;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.*;

@Slf4j
public class SchemaHistoryDao {
    private final QueryRunner queryRunner;
    private final String col = "id, model, major_version, minor_version, patch_version, version, description, type, script_path, checksum, success, code_block_num, execution_time, created_by, created_time, update_by, update_time";

    public SchemaHistoryDao() {
        this.queryRunner = new QueryRunner();
    }

    public List<SchemaHistoryEntity> queryLastVersion(Connection conn, String tableName) throws SQLException {
        StringBuilder query_last_version_sql = new StringBuilder("select ").append(col);
        query_last_version_sql.append(" from ").append(tableName);
        query_last_version_sql.append(" order by major_version desc, minor_version desc, patch_version desc, created_time desc ");
        List<Map<String, Object>> restMapList = queryRunner.query(conn, query_last_version_sql.toString(), new MapListHandler());
        setLog(query_last_version_sql.toString(), new Object[]{}, restMapList);
        return listMap2ListBean(restMapList, SchemaHistoryEntity.class);
    }

    public SchemaHistoryEntity queryLastVersion(Connection conn, String tableName, String model) throws SQLException {
        StringBuilder query_last_version_sql = new StringBuilder("select ").append(col);
        query_last_version_sql.append(" from ").append(tableName);
        query_last_version_sql.append(" where model = ? and success = 1");
        query_last_version_sql.append(" order by major_version desc, minor_version desc, patch_version desc, created_time desc ");
        Map<String, Object> restMap = queryRunner.query(conn, query_last_version_sql.toString(), new MapHandler(), model);
        setLog(query_last_version_sql.toString(), new Object[]{model}, restMap);
        return map2Bean(restMap, SchemaHistoryEntity.class);
    }

    public SchemaHistoryEntity queryByVersion(Connection conn, String tableName, String model, String version) throws SQLException {
        StringBuilder query_by_version_sql = new StringBuilder("select ").append(col);
        query_by_version_sql.append(" from ").append(tableName);
        query_by_version_sql.append(" where model = ? and version = ?");
        query_by_version_sql.append(" order by major_version desc, minor_version desc, patch_version desc, created_time desc ");
        Map<String, Object> restMap = queryRunner.query(conn, query_by_version_sql.toString(), new MapHandler(), model, version);
        setLog(query_by_version_sql.toString(), new Object[]{model, version}, restMap);
        return map2Bean(restMap, SchemaHistoryEntity.class);
    }

    public SchemaHistoryEntity queryBaseLine(Connection conn, String tableName) throws SQLException {
        StringBuilder query_base_line_sql = new StringBuilder("select ").append(col);
        query_base_line_sql.append(" from ").append(tableName);
        query_base_line_sql.append(" where type = 'BaseLine'");
        Map<String, Object> restMap = queryRunner.query(conn, query_base_line_sql.toString(), new MapHandler());
        setLog(query_base_line_sql.toString(), new Object[]{}, restMap);
        return map2Bean(restMap, SchemaHistoryEntity.class);
    }

    public void insertOne(Connection conn, String tableName, SchemaHistoryEntity entity) throws SQLException {
        boolean canAutoIncrement = DatabaseIdProvider.getDatabaseCanAutoIncrement(conn);
        StringBuilder inset_sql = new StringBuilder();
        String col_insert = "model, major_version, minor_version, patch_version, version, description, type, script_path, checksum, success, code_block_num, execution_time, created_by";
        inset_sql.append("insert into ").append(tableName).append(" ( ");
        if (!canAutoIncrement) {
            inset_sql.append("id, ");
        }
        inset_sql.append(col_insert).append(" ) ");
        inset_sql.append(" values ");
        List<Object> params = new ArrayList<>();
        if (canAutoIncrement) {
            inset_sql.append(" (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        } else {
            inset_sql.append(" ( ");
            inset_sql.append("seq_");
            inset_sql.append(tableName);
            inset_sql.append("_id.nextval,");
            inset_sql.append("?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        }
        params.add(entity.getModel());
        params.add(entity.getMajorVersion());
        params.add(entity.getMinorVersion());
        params.add(entity.getPatchVersion());
        params.add(entity.getVersion());
        params.add(entity.getDescription());
        params.add(entity.getType());
        params.add(entity.getScriptPath());
        params.add(entity.getChecksum());
        params.add(entity.getSuccess());
        params.add(entity.getCodeBlockNum());
        params.add(entity.getExecutionTime());
        params.add(entity.getCreatedBy());
        int rs = queryRunner.execute(conn, inset_sql.toString(), params.toArray());
        setLog(inset_sql.toString(), params.toArray(), rs);
    }

    public int updateOne(Connection conn, String tableName, SchemaHistoryEntity entity) throws SQLException {
        if (entity.getId() == null) {
            throw new SQLException("更新程序，主键不能为空！");
        }
        List<Object> params = new ArrayList<>();
        StringBuilder sb = new StringBuilder();
        sb.append("update ").append(tableName).append(" set ");
        if (entity.getModel() != null && entity.getModel().length() != 0) {
            sb.append(" model = ?,");
            params.add(entity.getModel());
        }
        if (entity.getMajorVersion() != null) {
            sb.append(" major_version = ?,");
            params.add(entity.getMajorVersion());
        }
        if (entity.getMinorVersion() != null) {
            sb.append(" minor_version = ?,");
            params.add(entity.getMinorVersion());
        }
        if (entity.getPatchVersion() != null) {
            sb.append(" patch_version = ?,");
            params.add(entity.getPatchVersion());
        }
        if (entity.getVersion() != null && entity.getVersion().length() != 0) {
            sb.append(" version = ?,");
            params.add(entity.getVersion());
        }
        if (entity.getDescription() != null && entity.getDescription().length() != 0) {
            sb.append(" description = ?,");
            params.add(entity.getDescription());
        }
        if (entity.getType() != null && entity.getType().length() != 0) {
            sb.append(" type = ?,");
            params.add(entity.getType());
        }
        if (entity.getScriptPath() != null && entity.getScriptPath().length() != 0) {
            sb.append(" script_path = ?,");
            params.add(entity.getScriptPath());
        }
        if (entity.getChecksum() != null && entity.getChecksum().length() != 0) {
            sb.append(" checksum = ?,");
            params.add(entity.getChecksum());
        }
        if (entity.getSuccess() != null) {
            sb.append(" success = ?,");
            params.add(entity.getSuccess());
        }
        if (entity.getCodeBlockNum() != null) {
            sb.append(" code_block_num = ?,");
            params.add(entity.getCodeBlockNum());
        }
        if (entity.getExecutionTime() != null) {
            sb.append(" execution_time = ?,");
            params.add(entity.getExecutionTime());
        }
        if (entity.getUpdateBy() != null && entity.getUpdateBy().length() != 0) {
            sb.append(" update_by = ?,");
            params.add(entity.getUpdateBy());
        }
        if (entity.getUpdateTime() != null) {
            sb.append(" update_time = ?,");
            params.add(entity.getUpdateTime());
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" where id = ?");
        params.add(entity.getId());
        int r = queryRunner.update(conn, sb.toString(), params.toArray());
        setLog(sb.toString(), params.toArray(), r);
        return r;
    }

    private void setLog(String sql, Object[] params, Object rest) {
        log.debug("sql:{}", sql);
        log.debug("params:{}", Arrays.toString(params));
        log.debug("result:{}", rest);
    }

    private <T> List<T> listMap2ListBean(List<Map<String, Object>> mapList, Class<T> t) {
        return JSONArray.parseArray(JSONArray.toJSONString(mapList).toLowerCase(Locale.ROOT), t);
    }

    private <T> T map2Bean(Map<String, Object> map, Class<T> t) {
        return JSONObject.parseObject(JSONObject.toJSONString(map).toLowerCase(Locale.ROOT), t);
    }
}
