package website.dachuan.migration.service.task;

import lombok.extern.slf4j.Slf4j;
import website.dachuan.migration.entity.SchemaHistoryEntity;
import website.dachuan.migration.props.MigrationProps;
import website.dachuan.migration.service.ISchemaHistoryService;
import website.dachuan.migration.service.MigrationTask;

import java.sql.Connection;
import java.sql.SQLException;

@Slf4j
public class InsertBaselineTask implements MigrationTask {
    private final MigrationProps props;
    private final ISchemaHistoryService schemaHistoryService;

    public InsertBaselineTask(MigrationProps props, ISchemaHistoryService schemaHistoryService) {
        this.props = props;
        this.schemaHistoryService = schemaHistoryService;
    }

    @Override
    public Boolean doTask(Connection conn) throws SQLException {
        log.debug("数据库[{}] InsertBaselineTask doTask begin...", conn.getMetaData().getURL());
        SchemaHistoryEntity entity = new SchemaHistoryEntity();
        entity.setExecutionTime(0L);
        entity.setSuccess(1);
        entity.setCodeBlockNum(0);
        entity.setModel("none");
        entity.setType("BaseLine");
        entity.setCreatedBy("auto");
        entity.setVersion(props.getBaselineVersion());
        entity.setDescription("none");
        entity.setScriptPath("none");
        schemaHistoryService.insertOne(conn, props, entity);
        log.debug("数据库[{}] 基线版本 {} InsertBaselineTask doTask end...", conn.getMetaData().getURL(), props.getBaselineVersion());
        return true;
    }
}
