package website.dachuan.migration.service.task;

import lombok.extern.slf4j.Slf4j;
import net.sf.jsqlparser.JSQLParserException;
import website.dachuan.migration.bo.SQLScriptBo;
import website.dachuan.migration.dao.sql.SqlProviderStrategy;
import website.dachuan.migration.props.MigrationProps;
import website.dachuan.migration.service.MigrationTask;
import website.dachuan.migration.utils.Files;
import website.dachuan.migration.utils.SqlScriptCommon;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

@Slf4j
public class DeployInitTableTask implements MigrationTask {
    private final MigrationProps props;
    private final SqlScriptCommon sqlScriptCommon;

    public DeployInitTableTask(MigrationProps props, SqlScriptCommon sqlScriptCommon) {
        this.props = props;
        this.sqlScriptCommon = sqlScriptCommon;
    }

    @Override
    public Boolean doTask(Connection conn) throws SQLException, IOException, JSQLParserException, NoSuchAlgorithmException {
        log.debug("数据库[{}] DeployInitTableTask doTask begin...", conn.getMetaData().getURL());
        // 获取文件路径下的所有要执行的文件
        List<SQLScriptBo> scripts = this.createSqlScriptBo(conn);
        // 分步执行文件
        sqlScriptCommon.increaseDbVersion(conn, scripts, null, null);
        log.debug("数据库[{}] DeployInitTableTask doTask end...", conn.getMetaData().getURL());
        return true;
    }

    private List<SQLScriptBo> createSqlScriptBo(Connection conn) throws IOException, SQLException {
        List<SQLScriptBo> sqlScripts = new ArrayList<>();
        File folder = new File(Files.getTemp().getAbsolutePath() + File.separator + Files.getDirName(this.props.getScriptDirPath()) + File.separator + SqlProviderStrategy.getSqlProvider(conn).sqlDirName() + File.separator + "deploy_init");
        if (folder.exists()) {
            sqlScripts = sqlScriptCommon.listSqlScriptBo(conn, folder.getName(), folder, null, true);
        }
        return sqlScripts;
    }
}
