package website.dachuan.migration.service;

import website.dachuan.migration.entity.SchemaHistoryEntity;
import website.dachuan.migration.props.MigrationProps;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public interface ISchemaHistoryService {
    List<SchemaHistoryEntity> queryLastVersion(Connection conn, MigrationProps props) throws SQLException;

    /**
     * 查询模块下执行成功的版本最大的版本信息
     *
     * @param conn  数据库连接
     * @param props 配置属性
     * @param model 模块
     * @return 数据库版本信息
     * @throws SQLException 数据库异常
     */
    SchemaHistoryEntity queryLastVersion(Connection conn, MigrationProps props, String model) throws SQLException;

    /**
     * 查询某个版本sql执行情况
     *
     * @param conn    数据库连接
     * @param props   配置属性
     * @param model   模块
     * @param version 版本信息
     * @return 数据库版本信息
     * @throws SQLException 数据库异常
     */
    SchemaHistoryEntity queryByVersion(Connection conn, MigrationProps props, String model, String version) throws SQLException;

    SchemaHistoryEntity queryBaseLine(Connection conn, MigrationProps props) throws SQLException;

    void insertOne(Connection conn, MigrationProps props, SchemaHistoryEntity entity) throws SQLException;

    int updateOne(Connection conn, MigrationProps props, SchemaHistoryEntity entity) throws SQLException;
}
