package website.dachuan.migration.dao.sql.dialect;

import website.dachuan.migration.mapping.DatabaseId;
import website.dachuan.migration.mapping.provider.OracleDatabaseId;

public class OracleSqlProvider extends CommonSqlProvider {
    private final DatabaseId oracleDatabaseId = new OracleDatabaseId();

    @Override
    public DatabaseId[] key() {
        return new DatabaseId[]{
                oracleDatabaseId
        };
    }

    @Override
    public String sqlDirName() {
        return oracleDatabaseId.name();
    }

    @Override
    public String getListTablesSql() {
        return "select table_name from user_tables";
    }
}
