package website.dachuan.migration.dao;

import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.handlers.ColumnListHandler;
import website.dachuan.migration.dao.sql.SqlProvider;
import website.dachuan.migration.dao.sql.SqlProviderStrategy;
import website.dachuan.migration.service.IDBOperation;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

/**
 * 数据库 数据表统计相关sql
 */
public class DBOperationDao implements IDBOperation {
    private final QueryRunner queryRunner;

    public DBOperationDao() {
        this.queryRunner = new QueryRunner();
    }

    public List<String> listTables(Connection conn) throws SQLException {
        SqlProvider sqlProvider = SqlProviderStrategy.getSqlProvider(conn);
        String sql = sqlProvider.getListTablesSql();
        return queryRunner.query(conn, sqlClean(sql), new ColumnListHandler<>(1));
    }

    @Override
    public List<Map<String, String>> listColumn(Connection conn, String tableName) throws SQLException {
        return null;
    }

    private String sqlClean(String sql) {
        if (sql != null && !sql.isEmpty() && sql.endsWith(";")) {
            return sql.substring(0, sql.length() - 1);
        }
        return sql;
    }
}
