create table schema_history
(
    id             number(16)                             not null,
    model          varchar(32)                            not null,
    major_version  number(3)                              not null,
    minor_version  number(3)                              not null,
    patch_version  number(3)                              not null,
    version        varchar(16)                            not null,
    description    varchar(200) default 'none'            not null,
    type           varchar(20)                            not null,
    script_path    varchar(512)                           not null,
    checksum       varchar(32),
    success        number(1)                              not null,
    code_block_num number(16)                             not null,
    execution_time number(16)                             not null,
    created_by     varchar(100)                           not null,
    created_time   timestamp    default current_timestamp not null,
    update_by      varchar(100),
    update_time    timestamp,
    primary key (id),
    unique (model, version)
);
comment on table schema_history is '数据库版本控制表';
comment on column schema_history.id is '数据库版本ID';
comment on column schema_history.model is '约定：当前数据目录(例：MySQL)下是`文件夹`（模块）或者是`文件`（迭代脚本）[当前场景下model=base];多租户时公共脚本：common、租户脚本：tenant_id';
comment on column schema_history.major_version is '主版本号';
comment on column schema_history.minor_version is '次版本号';
comment on column schema_history.patch_version is '补丁版本号';
comment on column schema_history.version is '版本号';
comment on column schema_history.description is '脚本自定义名称';
comment on column schema_history.type is '版本类型:SQL/BaseLine';
comment on column schema_history.script_path is '脚本文件名';
comment on column schema_history.checksum is '脚本内容摘要(16进制)';
comment on column schema_history.success is '是否执行成功';
comment on column schema_history.code_block_num is '执行成功代码块个数';
comment on column schema_history.execution_time is '脚本安装耗时';
comment on column schema_history.created_by is '脚本安装时间,格式:[yyyy-MM-dd HH:mm:ss]';
comment on column schema_history.created_time is '脚本安装用户';
comment on column schema_history.update_by is '脚本更新用户';
comment on column schema_history.update_time is '脚本更新时间';
create sequence seq_schema_history_id
    minvalue 1 --最小值
    nomaxvalue --不设置最大值
    start with 1 --从1开始计数
    increment by 1 --每次加1个
    nocycle nocache; --一直累加，不循环,不缓存
