create table if not exists schema_history
(
    id             bigint unsigned not null auto_increment comment '数据库版本id',
    model          varchar(32)     not null comment '约定：当前数据目录(例：MySQL)下是`文件夹`（模块）或者是`文件`（迭代脚本）[当前场景下model=base];多租户时公共脚本：common、租户脚本：tenant_id',
    major_version  int             not null comment '主版本号',
    minor_version  int             not null comment '次版本号',
    patch_version  int             not null comment '补丁版本号',
    version        varchar(16)     not null comment '版本号',
    description    varchar(200)    not null default 'none' comment '脚本自定义名称',
    type           varchar(20)     not null comment '版本类型:sql/baseline',
    script_path    varchar(512)    not null comment '脚本文件名',
    checksum       varchar(32) comment '脚本内容摘要',
    success        tinyint         not null comment '是否执行成功',
    code_block_num int             not null comment '执行成功代码块个数',
    execution_time int             not null comment '脚本安装耗时',
    created_by     varchar(100)    not null comment '脚本安装用户',
    created_time   timestamp       not null default current_timestamp comment '脚本安装时间',
    update_by      varchar(100) comment '脚本更新用户',
    update_time    timestamp comment '脚本更新时间',
    primary key (id),
    unique (model, version)
) engine = InnoDB
  default charset = utf8mb4 comment = '数据库版本控制表';
