/*
 * Decompiled with CFR 0.152.
 */
package website.dachuan.migration.utils;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sf.jsqlparser.JSQLParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import website.dachuan.migration.bo.SQLScriptBo;
import website.dachuan.migration.bo.SuccessNum;
import website.dachuan.migration.entity.SchemaHistoryEntity;
import website.dachuan.migration.props.MigrationProps;
import website.dachuan.migration.service.ISchemaHistoryService;
import website.dachuan.migration.service.ISqlScriptRunner;
import website.dachuan.migration.utils.Files;

public class SqlScriptCommon {
    private static final Logger log = LoggerFactory.getLogger(SqlScriptCommon.class);
    private final ISchemaHistoryService schemaHistoryService;
    private final MigrationProps props;
    private final ISqlScriptRunner scriptRunner;

    public SqlScriptCommon(MigrationProps props, ISchemaHistoryService schemaHistoryService, ISqlScriptRunner scriptRunner) {
        this.schemaHistoryService = schemaHistoryService;
        this.props = props;
        this.scriptRunner = scriptRunner;
    }

    public List<SQLScriptBo> listTenantDir(Connection conn, File folder, boolean incremental, String tenantId) throws IOException, SQLException {
        ArrayList<SQLScriptBo> sqlScripts = new ArrayList<SQLScriptBo>();
        if (folder.exists()) {
            File tenant;
            File common = new File(folder.getAbsolutePath() + File.separator + "common");
            if (common.exists()) {
                sqlScripts.addAll(this.listSqlScriptBo(conn, (incremental ? "common_" : "deploy_init_common_") + tenantId, common, tenantId, true));
            }
            if ((tenant = new File(folder.getAbsolutePath() + File.separator + tenantId)).exists()) {
                sqlScripts.addAll(this.listSqlScriptBo(conn, (incremental ? "" : "deploy_init_") + tenantId, tenant, tenantId, true));
            }
            return sqlScripts;
        }
        return sqlScripts;
    }

    public List<SQLScriptBo> listSqlScriptBo(Connection conn, String model, File dir, String tenantId, boolean recursion) throws IOException, SQLException {
        List<File> sqlFiles;
        SchemaHistoryEntity entity = this.schemaHistoryService.queryLastVersion(conn, this.props, model);
        if (entity == null) {
            entity = this.schemaHistoryService.queryBaseLine(conn, this.props);
        }
        if (recursion) {
            try (Stream<Path> paths = java.nio.file.Files.walk(Paths.get(dir.getAbsolutePath(), new String[0]), new FileVisitOption[0]);){
                sqlFiles = paths.map(Path::toFile).filter(f -> f.isFile() && f.getPath().endsWith(this.props.getSqlMigrationSuffix())).collect(Collectors.toList());
            }
        } else {
            File[] fs = dir.listFiles(f -> f.isFile() && f.getPath().endsWith(this.props.getSqlMigrationSuffix()));
            sqlFiles = Arrays.asList(fs == null ? new File[]{} : fs);
        }
        if (sqlFiles.size() == 0) {
            return new ArrayList<SQLScriptBo>(0);
        }
        int major = entity != null ? entity.getMajorVersion() : 0;
        int minor = entity != null ? entity.getMinorVersion() : 0;
        int patch = entity != null ? entity.getPatchVersion() : 0;
        List<SQLScriptBo> sqlScripts = sqlFiles.stream().map(f -> {
            int i;
            String[] p = f.getAbsolutePath().split("/|\\\\");
            if ("base".equals(model) || (("common_" + tenantId).equals(model) || ("deploy_init_common_" + tenantId).equals(model)) && "common".equals(p[p.length - 2]) || ("deploy_init_" + tenantId).equals(model) && tenantId != null && tenantId.equals(p[p.length - 2]) || tenantId != null && tenantId.equals(p[p.length - 2]) || model.equals(p[p.length - 2])) {
                return new SQLScriptBo(this.props, model, f.getName(), (File)f);
            }
            if (tenantId != null && ("common_" + tenantId).equals(model)) {
                i = Arrays.asList(p).indexOf("common");
                p[i] = "common_" + tenantId;
            } else if (tenantId != null && ("deploy_init_common_" + tenantId).equals(model)) {
                i = Arrays.asList(p).indexOf("common");
                p[i] = "deploy_init_common_" + tenantId;
            } else {
                i = Arrays.asList(p).indexOf(model);
            }
            if (i < 0) {
                throw new IllegalArgumentException("\u811a\u672c\u6570\u636e\u5f02\u5e38\uff01");
            }
            CharSequence[] m = Arrays.copyOfRange(p, i, p.length - 1);
            return new SQLScriptBo(this.props, String.join((CharSequence)"_", m), f.getName(), (File)f);
        }).filter(bo -> bo.checkNeed(major, minor, patch)).sorted(SQLScriptBo::compareTo).collect(Collectors.toList());
        return sqlScripts;
    }

    public void listSqlScriptBoCheck(List<SQLScriptBo> sqlScripts) {
        Map<String, Long> versionGroup;
        Optional<Map.Entry> error;
        if (sqlScripts != null && sqlScripts.size() > 0 && (error = (versionGroup = sqlScripts.stream().collect(Collectors.groupingBy(b -> b.getModule() + ":" + b.getVersion(), Collectors.counting()))).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).findFirst()).isPresent()) {
            String e = (String)error.get().getKey();
            if (((String)error.get().getKey()).startsWith("common_")) {
                e = "common" + e.substring(e.lastIndexOf(":"));
            }
            throw new IllegalArgumentException("\u6570\u636e\u811a\u672c\u4e0d\u7b26\u5408\u89c4\u8303\uff1a\u3010 " + e + " \u3011\u4e0b\u5b58\u5728" + error.get().getValue() + "\u4e2a\u7248\u672c\u76f8\u540c\u7684sql\u6587\u4ef6\uff01");
        }
    }

    public void increaseDbVersion(Connection conn, List<SQLScriptBo> sqlScripts, String tenantCol, String tenantVal) throws SQLException, IOException, NoSuchAlgorithmException, JSQLParserException {
        for (SQLScriptBo sqlScriptBo : sqlScripts) {
            this.increaseDbVersion(conn, sqlScriptBo, tenantCol, tenantVal);
        }
    }

    private void increaseDbVersion(Connection conn, SQLScriptBo sqlScriptBo, String tenantCol, String tenantVal) throws IOException, SQLException, NoSuchAlgorithmException, JSQLParserException {
        String checksum = Files.getFileChecksum(MessageDigest.getInstance("MD5"), sqlScriptBo.getFile());
        SchemaHistoryEntity entity = this.schemaHistoryService.queryByVersion(conn, this.props, sqlScriptBo.getModule(), sqlScriptBo.getVersion());
        boolean insertFlag = true;
        if (entity == null) {
            entity = new SchemaHistoryEntity();
            entity.setCreatedBy("auto");
        } else {
            if (entity.getSuccess() == 1) {
                return;
            }
            if (entity.getChecksum().equals(checksum)) {
                return;
            }
            insertFlag = false;
            entity.setUpdateBy("auto");
            entity.setUpdateTime(new Date());
        }
        entity.setType("SQL");
        entity.setModel(sqlScriptBo.getModule());
        entity.setScriptPath(sqlScriptBo.getFile().getPath());
        entity.setMajorVersion(sqlScriptBo.getMajorVersion());
        entity.setMinorVersion(sqlScriptBo.getMinorVersion());
        entity.setPatchVersion(sqlScriptBo.getPatchVersion());
        entity.setVersion(sqlScriptBo.getVersion());
        entity.setDescription(sqlScriptBo.getDescription());
        entity.setChecksum(checksum);
        log.debug("\u6570\u636e\u5e93[{}] \u6267\u884c\u589e\u91cf\u811a\u672c:{}", (Object)conn.getMetaData().getURL(), (Object)sqlScriptBo.getFileName());
        LocalDateTime startTime = LocalDateTime.now();
        SuccessNum successNum = new SuccessNum();
        try {
            int startNum = 1;
            if (!insertFlag) {
                startNum = entity.getCodeBlockNum() + 1;
            }
            this.scriptRunner.runScript(conn, new FileReader(sqlScriptBo.getFile()), successNum, startNum, tenantCol, tenantVal);
            LocalDateTime stopTime = LocalDateTime.now();
            long mills = Duration.between(startTime, stopTime).toMillis();
            log.debug("\u6570\u636e\u5e93[{}] \u6267\u884c\u589e\u91cf\u811a\u672c:{} , \u72b6\u6001: \u6210\u529f , \u6267\u884c\u8017\u65f6 : {} ms.", new Object[]{conn.getMetaData().getURL(), sqlScriptBo.getFileName(), mills});
            entity.setSuccess(1);
            entity.setCodeBlockNum(successNum.value());
            entity.setExecutionTime(mills);
        }
        catch (Exception e) {
            LocalDateTime stopTime = LocalDateTime.now();
            long mills = Duration.between(startTime, stopTime).toMillis();
            entity.setSuccess(0);
            entity.setCodeBlockNum(successNum.value());
            entity.setExecutionTime(mills);
            log.debug("\u6570\u636e\u5e93[{}] \u6267\u884c\u589e\u91cf\u811a\u672c:{} , \u72b6\u6001: \u5931\u8d25 , \u6267\u884c\u8017\u65f6 : {} ms.", new Object[]{conn.getMetaData().getURL(), sqlScriptBo.getFileName(), mills});
            log.error("", (Throwable)e);
            throw e;
        }
        finally {
            if (insertFlag) {
                this.schemaHistoryService.insertOne(conn, this.props, entity);
            } else {
                this.schemaHistoryService.updateOne(conn, this.props, entity);
            }
        }
    }
}

