/*
 * Decompiled with CFR 0.152.
 */
package website.dachuan.migration.utils;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;
import net.sf.jsqlparser.expression.operators.relational.ItemsListVisitorAdapter;
import net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import net.sf.jsqlparser.expression.operators.relational.NamedExpressionList;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.update.Update;

public class SqlParseUtil {
    public static String addTenant(String sql, String tenantCol, String tenantVal) throws JSQLParserException {
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        if (statement instanceof Insert) {
            return SqlParseUtil.addTenant2Insert(statement, tenantCol, tenantVal);
        }
        if (statement instanceof Update) {
            return SqlParseUtil.addTenant2Update(statement, tenantCol, tenantVal);
        }
        if (statement instanceof Delete) {
            return SqlParseUtil.addTenant2Delete(statement, tenantCol, tenantVal);
        }
        return sql;
    }

    private static String addTenant2Insert(Statement statement, final String tenantCol, final String tenantVal) throws JSQLParserException {
        if (!(statement instanceof Insert)) {
            return statement.toString();
        }
        Insert insert = (Insert)statement;
        final List columns = insert.getColumns();
        if (columns == null || columns.size() == 0) {
            throw new JSQLParserException("insert \u8bed\u53e5\u4e0d\u89c4\u8303\uff0c\u7f3a\u5931columns\uff01");
        }
        ItemsList values = insert.getItemsList();
        if (values != null) {
            values.accept((ItemsListVisitor)new ItemsListVisitorAdapter(){

                public void visit(SubSelect subSelect) {
                    throw new UnsupportedOperationException("\u4e0d\u652f\u6301\uff01");
                }

                public void visit(NamedExpressionList namedExpressionList) {
                    throw new UnsupportedOperationException("\u4e0d\u652f\u6301\uff01");
                }

                public void visit(ExpressionList expressionList) {
                    AtomicInteger index = new AtomicInteger(-1);
                    Optional<Column> c = columns.stream().filter(column -> {
                        index.getAndIncrement();
                        return tenantCol.equals(SqlParseUtil.parseColumnName(column.getColumnName()));
                    }).findFirst();
                    List expressions = expressionList.getExpressions();
                    if (c.isPresent()) {
                        Expression tenantExpression = (Expression)expressions.get(index.get());
                        if (!(tenantExpression instanceof StringValue)) {
                            throw new IllegalArgumentException("\u79df\u6237\u53f7\u7c7b\u578b\u5f02\u5e38\uff0c\u79df\u6237\u53f7\u5fc5\u987b\u4e3aString\uff01");
                        }
                        String it = ((StringValue)tenantExpression).getValue();
                        if (tenantVal.equals(it)) {
                            return;
                        }
                        throw new IllegalArgumentException("sql\u4e2d \u5305\u542b\u79df\u6237\u53f7\u4e0e\u79df\u6237\u4fe1\u606f\uff0c\u4f46\u5f53\u79df\u6237\u4fe1\u606f\u4e0e\u9700\u8981\u6dfb\u52a0\u7684\u79df\u6237\u4fe1\u606f\u4e0d\u540c\uff01");
                    }
                    columns.add(new Column(tenantCol));
                    expressionList.addExpressions(new Expression[]{new StringValue(tenantVal)});
                }

                public void visit(MultiExpressionList multiExprList) {
                    throw new UnsupportedOperationException("\u4e0d\u652f\u6301\uff01");
                }
            });
        }
        return insert.toString();
    }

    private static String addTenant2Update(Statement statement, String tenantCol, String tenantVal) throws JSQLParserException {
        if (!(statement instanceof Update)) {
            return statement.toString();
        }
        Update update = (Update)statement;
        Expression newExpression = SqlParseUtil.parseWhere(update.getWhere(), tenantCol, tenantVal);
        update.setWhere(newExpression);
        return update.toString();
    }

    private static String addTenant2Delete(Statement statement, String tenantCol, String tenantVal) throws JSQLParserException {
        if (!(statement instanceof Delete)) {
            return statement.toString();
        }
        Delete delete = (Delete)statement;
        Expression newExpression = SqlParseUtil.parseWhere(delete.getWhere(), tenantCol, tenantVal);
        delete.setWhere(newExpression);
        return delete.toString();
    }

    private static Expression parseWhere(Expression currentExpression, final String tenantCol, final String tenantVal) {
        EqualsTo equalsTo = new EqualsTo();
        equalsTo.setLeftExpression((Expression)new Column(tenantCol));
        equalsTo.setRightExpression((Expression)new StringValue(tenantVal));
        final AtomicBoolean exist = new AtomicBoolean(false);
        if (currentExpression != null) {
            currentExpression.accept((ExpressionVisitor)new ExpressionVisitorAdapter(){

                public void visit(EqualsTo expr) {
                    Column column = (Column)expr.getLeftExpression();
                    if (tenantCol.equals(SqlParseUtil.parseColumnName(column.getColumnName()))) {
                        if (!(expr.getRightExpression() instanceof StringValue)) {
                            throw new IllegalArgumentException("\u79df\u6237\u53f7\u7c7b\u578b\u5f02\u5e38\uff0c\u79df\u6237\u53f7\u5fc5\u987b\u4e3aString\uff01");
                        }
                        String it = ((StringValue)expr.getRightExpression()).getValue();
                        if (tenantVal.equals(it)) {
                            exist.set(true);
                        } else {
                            throw new IllegalArgumentException("sql\u4e2d \u5305\u542b\u79df\u6237\u53f7\u4e0e\u79df\u6237\u4fe1\u606f\uff0c\u4f46\u5f53\u79df\u6237\u4fe1\u606f\u4e0e\u9700\u8981\u6dfb\u52a0\u7684\u79df\u6237\u4fe1\u606f\u4e0d\u540c\uff01");
                        }
                    }
                }
            });
        }
        if (exist.get()) {
            return currentExpression;
        }
        Object newExpression = currentExpression == null ? equalsTo : (currentExpression instanceof OrExpression ? new AndExpression((Expression)new Parenthesis(currentExpression), (Expression)equalsTo) : new AndExpression(currentExpression, (Expression)equalsTo));
        return newExpression;
    }

    private static String parseColumnName(String columnName) {
        if (columnName == null || columnName.isEmpty()) {
            return columnName;
        }
        return columnName.replaceAll("\"", "");
    }
}

