/*
 * Decompiled with CFR 0.152.
 */
package website.dachuan.migration.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;

public class Files {
    public static String getFileChecksum(MessageDigest digest, File file) throws IOException {
        int bytesCount;
        FileInputStream fis = new FileInputStream(file);
        byte[] byteArray = new byte[1024];
        while ((bytesCount = fis.read(byteArray)) != -1) {
            digest.update(byteArray, 0, bytesCount);
        }
        fis.close();
        byte[] bytes = digest.digest();
        StringBuilder sb = new StringBuilder();
        for (byte aByte : bytes) {
            sb.append(Integer.toString((aByte & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    public static List<File> getAllFiles(File root) {
        ArrayList<File> files = new ArrayList<File>();
        Files.getAllFile(root, files);
        return files;
    }

    private static void getAllFile(File root, List<File> files) {
        if (root != null && root.exists() && root.isDirectory()) {
            File[] fs = root.listFiles();
            if (files != null) {
                for (File f : fs) {
                    if (f.isFile()) {
                        files.add(f);
                    }
                    if (!f.isDirectory()) continue;
                    Files.getAllFile(f, files);
                }
            }
        }
    }
}

