/*
 * Decompiled with CFR 0.152.
 */
package website.dachuan.migration.utils;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseIdProvider {
    private static final Logger log = LoggerFactory.getLogger(DatabaseIdProvider.class);

    public static String getDatabaseId(Connection connection) {
        if (connection == null) {
            throw new NullPointerException("DatabaseIdProvider connection cannot be null");
        }
        try {
            String productName = connection.getMetaData().getDatabaseProductName();
            String url = connection.getMetaData().getURL();
            if (url.toLowerCase().contains(productName.toLowerCase())) {
                return DatabaseId.valueOf(productName).name();
            }
            String[] urls = url.split(":");
            return DatabaseId.uk(urls[1]).name();
        }
        catch (SQLException e) {
            log.error(log.getName(), (Throwable)e);
            return DatabaseId.NnKnown.name();
        }
    }

    public static enum DatabaseId {
        MySQL("mysql", false),
        PostgreSQL("postgresql", true),
        HighGo("highgo", true),
        NnKnown("unknown", false);

        public final String uk;
        public final boolean ddlTransaction;

        private DatabaseId(String uk, boolean ddlTransaction) {
            this.uk = uk;
            this.ddlTransaction = ddlTransaction;
        }

        static DatabaseId uk(String uk) {
            Optional<DatabaseId> r = Arrays.stream(DatabaseId.values()).filter(databaseId -> databaseId.uk.equals(uk)).findFirst();
            return r.orElse(NnKnown);
        }
    }
}

