/*
 * Decompiled with CFR 0.152.
 */
package website.dachuan.migration.service.task;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.JSQLParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import website.dachuan.migration.bo.SQLScriptBo;
import website.dachuan.migration.props.MigrationProps;
import website.dachuan.migration.service.MigrationTask;
import website.dachuan.migration.utils.DatabaseIdProvider;
import website.dachuan.migration.utils.SqlScriptCommon;

public class TenantDataInitScriptTask
implements MigrationTask {
    private static final Logger log = LoggerFactory.getLogger(TenantDataInitScriptTask.class);
    private final MigrationProps props;
    private final SqlScriptCommon sqlScriptCommon;
    private final String tenantId;

    public TenantDataInitScriptTask(MigrationProps props, SqlScriptCommon sqlScriptCommon, String tenantId) {
        this.props = props;
        this.sqlScriptCommon = sqlScriptCommon;
        this.tenantId = tenantId;
    }

    @Override
    public Boolean doTask(Connection conn) throws SQLException, IOException, JSQLParserException, NoSuchAlgorithmException {
        log.debug("\u6570\u636e\u5e93[{}] TenantDataInitScriptTask doTask begin ...", (Object)conn.getMetaData().getURL());
        List<SQLScriptBo> scripts = this.createSqlScriptBo(conn);
        this.sqlScriptCommon.increaseDbVersion(conn, scripts, this.props.getTenantData().getTenantIdColumn(), this.tenantId);
        log.debug("\u6570\u636e\u5e93[{}] TenantDataInitScriptTask doTask end ...", (Object)conn.getMetaData().getURL());
        return true;
    }

    private List<SQLScriptBo> createSqlScriptBo(Connection conn) throws IOException, SQLException {
        File folder;
        if (this.props.getTenantData().getScriptDirPath().startsWith("classpath:") || !this.props.getTenantData().getScriptDirPath().startsWith("/")) {
            URL url = this.getClass().getClassLoader().getResource(this.props.getTenantData().getScriptDirPath());
            if (url == null) {
                return new ArrayList<SQLScriptBo>();
            }
            folder = new File(url.getFile() + File.separator + DatabaseIdProvider.getDatabaseId(conn) + File.separator + "deploy_init");
        } else {
            folder = new File(this.props.getTenantData().getScriptDirPath() + File.separator + DatabaseIdProvider.getDatabaseId(conn) + File.separator + "deploy_init");
        }
        if (!folder.exists()) {
            return new ArrayList<SQLScriptBo>();
        }
        return this.sqlScriptCommon.listTenantDir(conn, folder, false, this.tenantId);
    }
}

