/*
 * Decompiled with CFR 0.152.
 */
package website.dachuan.migration.service.task;

import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import website.dachuan.migration.entity.SchemaHistoryEntity;
import website.dachuan.migration.props.MigrationProps;
import website.dachuan.migration.service.ISchemaHistoryService;
import website.dachuan.migration.service.MigrationTask;

public class InsertBaselineTask
implements MigrationTask {
    private static final Logger log = LoggerFactory.getLogger(InsertBaselineTask.class);
    private final MigrationProps props;
    private final ISchemaHistoryService schemaHistoryService;

    public InsertBaselineTask(MigrationProps props, ISchemaHistoryService schemaHistoryService) {
        this.props = props;
        this.schemaHistoryService = schemaHistoryService;
    }

    @Override
    public Boolean doTask(Connection conn) throws SQLException {
        log.debug("\u6570\u636e\u5e93[{}] InsertBaselineTask doTask begin...", (Object)conn.getMetaData().getURL());
        SchemaHistoryEntity entity = new SchemaHistoryEntity();
        entity.setExecutionTime(0L);
        entity.setSuccess(1);
        entity.setCodeBlockNum(0);
        entity.setModel("none");
        entity.setType("BaseLine");
        entity.setCreatedBy("auto");
        entity.setVersion(this.props.getBaselineVersion());
        entity.setDescription("none");
        entity.setScriptPath("none");
        this.schemaHistoryService.insertOne(conn, this.props, entity);
        log.debug("\u6570\u636e\u5e93[{}] \u57fa\u7ebf\u7248\u672c {} InsertBaselineTask doTask end...", (Object)conn.getMetaData().getURL(), (Object)this.props.getBaselineVersion());
        return true;
    }
}

