/*
 * Decompiled with CFR 0.152.
 */
package website.dachuan.migration.service.task;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.JSQLParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import website.dachuan.migration.bo.SQLScriptBo;
import website.dachuan.migration.props.MigrationProps;
import website.dachuan.migration.service.MigrationTask;
import website.dachuan.migration.utils.DatabaseIdProvider;
import website.dachuan.migration.utils.SqlScriptCommon;

public class IncreaseVersionTask
implements MigrationTask {
    private static final Logger log = LoggerFactory.getLogger(IncreaseVersionTask.class);
    private final MigrationProps props;
    private final SqlScriptCommon sqlScriptCommon;

    public IncreaseVersionTask(MigrationProps props, SqlScriptCommon sqlScriptCommon) {
        this.props = props;
        this.sqlScriptCommon = sqlScriptCommon;
    }

    @Override
    public Boolean doTask(Connection conn) throws IOException, SQLException, NoSuchAlgorithmException, JSQLParserException {
        log.debug("\u6570\u636e\u5e93[{}] IncreaseVersionTask doTask begin ...", (Object)conn.getMetaData().getURL());
        List<SQLScriptBo> scripts = this.createSqlScriptBo(conn);
        this.sqlScriptCommon.listSqlScriptBoCheck(scripts);
        this.sqlScriptCommon.increaseDbVersion(conn, scripts, null, null);
        log.debug("\u6570\u636e\u5e93[{}] IncreaseVersionTask doTask end ...", (Object)conn.getMetaData().getURL());
        return true;
    }

    private List<SQLScriptBo> createSqlScriptBo(Connection conn) throws IOException, SQLException {
        File folder;
        ArrayList<SQLScriptBo> sqlScripts = new ArrayList<SQLScriptBo>();
        if (this.props.getScriptDirPath().startsWith("classpath:") || !this.props.getScriptDirPath().startsWith("/")) {
            URL url = this.getClass().getClassLoader().getResource(this.props.getScriptDirPath());
            if (url == null) {
                return sqlScripts;
            }
            folder = new File(url.getFile() + File.separator + DatabaseIdProvider.getDatabaseId(conn));
        } else {
            folder = new File(this.props.getScriptDirPath() + File.separator + DatabaseIdProvider.getDatabaseId(conn));
        }
        if (folder.exists()) {
            File[] l_model = folder.listFiles(File::isDirectory);
            if (l_model != null) {
                for (File dir : l_model) {
                    List<SQLScriptBo> temp;
                    if ("deploy_init".equals(dir.getName()) || (temp = this.sqlScriptCommon.listSqlScriptBo(conn, dir.getName(), dir, null, true)) == null || temp.size() <= 0) continue;
                    sqlScripts.addAll(temp);
                }
            }
            sqlScripts.addAll(this.sqlScriptCommon.listSqlScriptBo(conn, "base", folder, null, false));
        }
        return sqlScripts;
    }
}

