/*
 * Decompiled with CFR 0.152.
 */
package website.dachuan.migration.service.task;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.JSQLParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import website.dachuan.migration.bo.SQLScriptBo;
import website.dachuan.migration.props.MigrationProps;
import website.dachuan.migration.service.MigrationTask;
import website.dachuan.migration.utils.DatabaseIdProvider;
import website.dachuan.migration.utils.SqlScriptCommon;

public class DeployInitTableTask
implements MigrationTask {
    private static final Logger log = LoggerFactory.getLogger(DeployInitTableTask.class);
    private final MigrationProps props;
    private final SqlScriptCommon sqlScriptCommon;

    public DeployInitTableTask(MigrationProps props, SqlScriptCommon sqlScriptCommon) {
        this.props = props;
        this.sqlScriptCommon = sqlScriptCommon;
    }

    @Override
    public Boolean doTask(Connection conn) throws SQLException, IOException, JSQLParserException, NoSuchAlgorithmException {
        log.debug("\u6570\u636e\u5e93[{}] DeployInitTableTask doTask begin...", (Object)conn.getMetaData().getURL());
        List<SQLScriptBo> scripts = this.createSqlScriptBo(conn);
        this.sqlScriptCommon.increaseDbVersion(conn, scripts, null, null);
        log.debug("\u6570\u636e\u5e93[{}] DeployInitTableTask doTask end...", (Object)conn.getMetaData().getURL());
        return true;
    }

    private List<SQLScriptBo> createSqlScriptBo(Connection conn) throws IOException, SQLException {
        File folder;
        List<SQLScriptBo> sqlScripts = new ArrayList<SQLScriptBo>();
        if (this.props.getScriptDirPath().startsWith("classpath:") || !this.props.getScriptDirPath().startsWith("/")) {
            URL url = this.getClass().getClassLoader().getResource(this.props.getScriptDirPath());
            if (url == null) {
                return sqlScripts;
            }
            folder = new File(url.getFile() + File.separator + DatabaseIdProvider.getDatabaseId(conn) + File.separator + "deploy_init");
        } else {
            folder = new File(this.props.getScriptDirPath() + File.separator + DatabaseIdProvider.getDatabaseId(conn) + File.separator + "deploy_init");
        }
        if (folder.exists()) {
            sqlScripts = this.sqlScriptCommon.listSqlScriptBo(conn, folder.getName(), folder, null, true);
        }
        return sqlScripts;
    }
}

