/*
 * Decompiled with CFR 0.152.
 */
package website.dachuan.migration.service.task;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import website.dachuan.migration.bo.SuccessNum;
import website.dachuan.migration.props.MigrationProps;
import website.dachuan.migration.service.ISqlScriptRunner;
import website.dachuan.migration.service.MigrationTask;
import website.dachuan.migration.utils.DatabaseIdProvider;

public class CreateHistoryTableTask
implements MigrationTask {
    private static final Logger log = LoggerFactory.getLogger(CreateHistoryTableTask.class);
    private final MigrationProps props;
    private final ISqlScriptRunner scriptRunner;

    public CreateHistoryTableTask(MigrationProps props, ISqlScriptRunner scriptRunner) {
        this.props = props;
        this.scriptRunner = scriptRunner;
    }

    @Override
    public Boolean doTask(Connection conn) throws SQLException {
        log.debug("\u6570\u636e\u5e93[{}] CreateHistoryTableTask doTask begin...", (Object)conn.getMetaData().getURL());
        String defaultCreateSchemaHistoryTableSqlPath = String.format("db/%s/schema_history.sql", DatabaseIdProvider.getDatabaseId(conn));
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(defaultCreateSchemaHistoryTableSqlPath);
        assert (is != null);
        Reader reader = this.props.getSchemaHistoryTableName() != null && this.props.getSchemaHistoryTableName().length() > 0 && !"schema_history".equals(this.props.getSchemaHistoryTableName()) ? this.readSqlScript(is) : new InputStreamReader(is);
        this.scriptRunner.runScript(conn, reader, new SuccessNum());
        log.debug("\u6570\u636e\u5e93[{}] CreateHistoryTableTask doTask end...", (Object)conn.getMetaData().getURL());
        return true;
    }

    private Reader readSqlScript(InputStream is) {
        ArrayList<String> sqlScript = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            String line;
            StringBuilder sqlBuilder = new StringBuilder();
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.startsWith("--")) continue;
                if (line.contains("schema_history")) {
                    line = line.replace("schema_history", this.props.getSchemaHistoryTableName());
                }
                if (line.endsWith(";")) {
                    sqlBuilder.append(line);
                    sqlScript.add(sqlBuilder.toString());
                    sqlBuilder.delete(0, sqlBuilder.length());
                    continue;
                }
                sqlBuilder.append(line).append(" \n");
            }
            if (sqlBuilder.length() > 0) {
                sqlBuilder.append(";");
                sqlScript.add(sqlBuilder.toString());
                sqlBuilder.delete(0, sqlBuilder.length());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sqlScript.stream().reduce((a, b) -> a + "\n" + b).map(StringReader::new).orElse(null);
    }
}

