/*
 * Decompiled with CFR 0.152.
 */
package website.dachuan.migration.service;

import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.JSQLParserException;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import website.dachuan.migration.bo.SuccessNum;
import website.dachuan.migration.service.ISqlScriptRunner;
import website.dachuan.migration.utils.SqlParseUtil;
import website.dachuan.migration.utils.SqlScriptReader;

public class SqlScriptRunner
implements ISqlScriptRunner {
    private static final Logger log = LoggerFactory.getLogger(SqlScriptRunner.class);
    private final QueryRunner runner = new QueryRunner();

    @Override
    public List<Map<String, Object>> runScript(Connection conn, String sql, Object ... param) throws SQLException {
        MapListHandler rsh = new MapListHandler();
        return (List)this.runner.query(conn, sql, (ResultSetHandler)rsh);
    }

    @Override
    public void runScript(Connection conn, Reader reader, SuccessNum successNum) throws SQLException {
        this.runScript(conn, reader, successNum, 1);
    }

    @Override
    public void runScript(Connection conn, Reader reader, SuccessNum successNum, int startNum) throws SQLException {
        if (startNum < 1) {
            startNum = 1;
        }
        List<String> sqlList = SqlScriptReader.readSqlScript(reader);
        for (int i = startNum - 1; i < sqlList.size(); ++i) {
            this.runner.update(conn, sqlList.get(i));
            successNum.setNum(i + 1);
        }
    }

    @Override
    public void runScript(Connection conn, Reader reader, SuccessNum successNum, int startNum, String tenantCol, String tenantVal) throws SQLException, JSQLParserException {
        if (tenantCol == null || tenantCol.length() == 0 || tenantVal == null || tenantVal.length() == 0) {
            this.runScript(conn, reader, successNum, startNum);
        } else {
            if (startNum < 1) {
                startNum = 1;
            }
            List<String> sqlList = SqlScriptReader.readSqlScript(reader);
            for (int i = startNum - 1; i < sqlList.size(); ++i) {
                String sql = SqlParseUtil.addTenant(sqlList.get(i), tenantCol, tenantVal);
                this.runner.update(conn, sql);
                successNum.setNum(i + 1);
            }
        }
    }
}

