/*
 * Decompiled with CFR 0.152.
 */
package website.dachuan.migration.dao;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.commons.dbutils.BeanProcessor;
import org.apache.commons.dbutils.GenerousBeanProcessor;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import website.dachuan.migration.entity.SchemaHistoryEntity;

public class SchemaHistoryDao {
    private static final Logger log = LoggerFactory.getLogger(SchemaHistoryDao.class);
    private final QueryRunner queryRunner;
    private final RowProcessor processor = new BasicRowProcessor((BeanProcessor)new GenerousBeanProcessor());
    private final String col = "id, model, major_version, minor_version, patch_version, version, description, type, script_path, checksum, success, code_block_num, execution_time, created_by, created_time, update_by, update_time";

    public SchemaHistoryDao() {
        this.queryRunner = new QueryRunner();
    }

    public List<SchemaHistoryEntity> queryLastVersion(Connection conn, String tableName) throws SQLException {
        StringBuilder query_last_version_sql = new StringBuilder("select ").append("id, model, major_version, minor_version, patch_version, version, description, type, script_path, checksum, success, code_block_num, execution_time, created_by, created_time, update_by, update_time");
        query_last_version_sql.append(" from ").append(tableName);
        query_last_version_sql.append(" order by major_version desc, minor_version desc, patch_version desc, created_time desc ");
        BeanListHandler resultSetHandler = new BeanListHandler(SchemaHistoryEntity.class, this.processor);
        log.debug(query_last_version_sql.toString());
        return (List)this.queryRunner.query(conn, query_last_version_sql.toString(), (ResultSetHandler)resultSetHandler);
    }

    public SchemaHistoryEntity queryLastVersion(Connection conn, String tableName, String model) throws SQLException {
        StringBuilder query_last_version_sql = new StringBuilder("select ").append("id, model, major_version, minor_version, patch_version, version, description, type, script_path, checksum, success, code_block_num, execution_time, created_by, created_time, update_by, update_time");
        query_last_version_sql.append(" from ").append(tableName);
        query_last_version_sql.append(" where model = ? and success = 1");
        query_last_version_sql.append(" order by major_version desc, minor_version desc, patch_version desc, created_time desc ");
        BeanHandler resultSetHandler = new BeanHandler(SchemaHistoryEntity.class, this.processor);
        log.debug(query_last_version_sql.toString());
        log.debug("params[{}]", (Object)model);
        return (SchemaHistoryEntity)this.queryRunner.query(conn, query_last_version_sql.toString(), (ResultSetHandler)resultSetHandler, new Object[]{model});
    }

    public SchemaHistoryEntity queryByVersion(Connection conn, String tableName, String model, String version) throws SQLException {
        StringBuilder query_by_version_sql = new StringBuilder("select ").append("id, model, major_version, minor_version, patch_version, version, description, type, script_path, checksum, success, code_block_num, execution_time, created_by, created_time, update_by, update_time");
        query_by_version_sql.append(" from ").append(tableName);
        query_by_version_sql.append(" where model = ? and version = ?");
        query_by_version_sql.append(" order by major_version desc, minor_version desc, patch_version desc, created_time desc ");
        BeanHandler resultSetHandler = new BeanHandler(SchemaHistoryEntity.class, this.processor);
        log.debug(query_by_version_sql.toString());
        log.debug("params[{},{}]", (Object)model, (Object)version);
        return (SchemaHistoryEntity)this.queryRunner.query(conn, query_by_version_sql.toString(), (ResultSetHandler)resultSetHandler, new Object[]{model, version});
    }

    public SchemaHistoryEntity queryBaseLine(Connection conn, String tableName) throws SQLException {
        StringBuilder query_base_line_sql = new StringBuilder("select ").append("id, model, major_version, minor_version, patch_version, version, description, type, script_path, checksum, success, code_block_num, execution_time, created_by, created_time, update_by, update_time");
        query_base_line_sql.append(" from ").append(tableName);
        query_base_line_sql.append(" where type = 'BaseLine';");
        BeanHandler resultSetHandler = new BeanHandler(SchemaHistoryEntity.class, this.processor);
        log.debug(query_base_line_sql.toString());
        return (SchemaHistoryEntity)this.queryRunner.query(conn, query_base_line_sql.toString(), (ResultSetHandler)resultSetHandler);
    }

    public SchemaHistoryEntity insertOne(Connection conn, String tableName, SchemaHistoryEntity entity) throws SQLException {
        StringBuilder inset_sql = new StringBuilder();
        String col_insert = "model, major_version, minor_version, patch_version, version, description, type, script_path, checksum, success, code_block_num, execution_time, created_by";
        inset_sql.append("insert into ").append(tableName).append(" ( ").append(col_insert).append(" ) ");
        inset_sql.append(" values ");
        inset_sql.append(" (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);");
        log.debug(inset_sql.toString());
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(entity.getModel());
        params.add(entity.getMajorVersion());
        params.add(entity.getMinorVersion());
        params.add(entity.getPatchVersion());
        params.add(entity.getVersion());
        params.add(entity.getDescription());
        params.add(entity.getType());
        params.add(entity.getScriptPath());
        params.add(entity.getChecksum());
        params.add(entity.getSuccess());
        params.add(entity.getCodeBlockNum());
        params.add(entity.getExecutionTime());
        params.add(entity.getCreatedBy());
        log.debug("params:{}", params);
        Object rs = this.queryRunner.insert(conn, inset_sql.toString(), (ResultSetHandler)new ScalarHandler(), params.toArray());
        entity.setId(Long.parseLong(rs.toString()));
        return entity;
    }

    public int updateOne(Connection conn, String tableName, SchemaHistoryEntity entity) throws SQLException {
        if (entity.getId() == null) {
            throw new SQLException("\u66f4\u65b0\u7a0b\u5e8f\uff0c\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder sb = new StringBuilder();
        sb.append("update ").append(tableName).append(" set ");
        if (entity.getModel() != null && entity.getModel().length() != 0) {
            sb.append(" model = ?,");
            params.add(entity.getModel());
        }
        if (entity.getMajorVersion() != null) {
            sb.append(" major_version = ?,");
            params.add(entity.getMajorVersion());
        }
        if (entity.getMinorVersion() != null) {
            sb.append(" minor_version = ?,");
            params.add(entity.getMinorVersion());
        }
        if (entity.getPatchVersion() != null) {
            sb.append(" patch_version = ?,");
            params.add(entity.getPatchVersion());
        }
        if (entity.getVersion() != null && entity.getVersion().length() != 0) {
            sb.append(" version = ?,");
            params.add(entity.getVersion());
        }
        if (entity.getDescription() != null && entity.getDescription().length() != 0) {
            sb.append(" description = ?,");
            params.add(entity.getDescription());
        }
        if (entity.getType() != null && entity.getType().length() != 0) {
            sb.append(" type = ?,");
            params.add(entity.getType());
        }
        if (entity.getScriptPath() != null && entity.getScriptPath().length() != 0) {
            sb.append(" script_path = ?,");
            params.add(entity.getScriptPath());
        }
        if (entity.getChecksum() != null && entity.getChecksum().length() != 0) {
            sb.append(" checksum = ?,");
            params.add(entity.getChecksum());
        }
        if (entity.getSuccess() != null) {
            sb.append(" success = ?,");
            params.add(entity.getSuccess());
        }
        if (entity.getCodeBlockNum() != null) {
            sb.append(" code_block_num = ?,");
            params.add(entity.getCodeBlockNum());
        }
        if (entity.getExecutionTime() != null) {
            sb.append(" execution_time = ?,");
            params.add(entity.getExecutionTime());
        }
        if (entity.getUpdateBy() != null && entity.getUpdateBy().length() != 0) {
            sb.append(" update_by = ?,");
            params.add(entity.getUpdateBy());
        }
        if (entity.getUpdateTime() != null) {
            sb.append(" update_time = ?,");
            params.add(entity.getUpdateTime());
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" where id = ?");
        params.add(entity.getId());
        log.debug(sb.toString());
        log.debug("params:{}", params);
        return this.queryRunner.update(conn, sb.toString(), params.toArray());
    }
}

