/*
 * Decompiled with CFR 0.152.
 */
package website.dachuan.migration.bo;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import website.dachuan.migration.props.MigrationProps;

public class SQLScriptBo
implements Comparable<SQLScriptBo> {
    private static final Logger log = LoggerFactory.getLogger(SQLScriptBo.class);
    private Pattern PTN_SCRIPT_NAME;
    private String module;
    private String fileName;
    private File file;
    private int majorVersion;
    private int minorVersion;
    private int patchVersion;
    private String version;
    private String description;

    public SQLScriptBo(MigrationProps props, String model, String fileName, File file) {
        this.PTN_SCRIPT_NAME = Pattern.compile(String.format("^%s%s(\\d+)\\.(\\d+)\\.(\\d+)%s(\\w+)%s$", props.getSqlMigrationPrefix(), props.getSqlMigrationSeparator(), props.getSqlMigrationSeparator(), props.getSqlMigrationSuffix()));
        this.fileName = fileName;
        this.file = file;
        this.module = model;
        if (model != null && model.startsWith("deploy_init")) {
            this.majorVersion = 1;
            this.minorVersion = 0;
            this.patchVersion = 0;
            this.description = "deploy_init";
            this.version = String.format("%s.%s.%s", this.majorVersion, this.minorVersion, this.patchVersion);
        } else {
            Matcher matcher = this.PTN_SCRIPT_NAME.matcher(fileName);
            if (matcher.matches()) {
                this.majorVersion = Integer.parseInt(matcher.group(1));
                this.minorVersion = Integer.parseInt(matcher.group(2));
                this.patchVersion = Integer.parseInt(matcher.group(3));
                this.description = matcher.group(4);
                this.version = String.format("%s.%s.%s", this.majorVersion, this.minorVersion, this.patchVersion);
            } else {
                throw new RuntimeException(fileName + " format is not correct!");
            }
        }
    }

    public boolean checkNeed(int major, int minor, int patch) {
        if (this.majorVersion < major) {
            return false;
        }
        if (this.majorVersion > major) {
            return true;
        }
        if (this.minorVersion < minor) {
            return false;
        }
        if (this.minorVersion > minor) {
            return true;
        }
        return this.patchVersion > patch;
    }

    @Override
    public int compareTo(SQLScriptBo o) {
        if (this.getMajorVersion() == o.getMajorVersion()) {
            if (this.getMinorVersion() == o.getMinorVersion()) {
                return Integer.compare(this.getPatchVersion(), o.getPatchVersion());
            }
            return Integer.compare(this.getMinorVersion(), o.getMinorVersion());
        }
        return Integer.compare(this.getMajorVersion(), o.getMajorVersion());
    }

    public Pattern getPTN_SCRIPT_NAME() {
        return this.PTN_SCRIPT_NAME;
    }

    public String getModule() {
        return this.module;
    }

    public String getFileName() {
        return this.fileName;
    }

    public File getFile() {
        return this.file;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getPatchVersion() {
        return this.patchVersion;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setPTN_SCRIPT_NAME(Pattern PTN_SCRIPT_NAME) {
        this.PTN_SCRIPT_NAME = PTN_SCRIPT_NAME;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setMajorVersion(int majorVersion) {
        this.majorVersion = majorVersion;
    }

    public void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    public void setPatchVersion(int patchVersion) {
        this.patchVersion = patchVersion;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SQLScriptBo)) {
            return false;
        }
        SQLScriptBo other = (SQLScriptBo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMajorVersion() != other.getMajorVersion()) {
            return false;
        }
        if (this.getMinorVersion() != other.getMinorVersion()) {
            return false;
        }
        if (this.getPatchVersion() != other.getPatchVersion()) {
            return false;
        }
        Pattern this$PTN_SCRIPT_NAME = this.getPTN_SCRIPT_NAME();
        Pattern other$PTN_SCRIPT_NAME = other.getPTN_SCRIPT_NAME();
        if (this$PTN_SCRIPT_NAME == null ? other$PTN_SCRIPT_NAME != null : !this$PTN_SCRIPT_NAME.equals(other$PTN_SCRIPT_NAME)) {
            return false;
        }
        String this$module = this.getModule();
        String other$module = other.getModule();
        if (this$module == null ? other$module != null : !this$module.equals(other$module)) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        File this$file = this.getFile();
        File other$file = other.getFile();
        if (this$file == null ? other$file != null : !((Object)this$file).equals(other$file)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SQLScriptBo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMajorVersion();
        result = result * 59 + this.getMinorVersion();
        result = result * 59 + this.getPatchVersion();
        Pattern $PTN_SCRIPT_NAME = this.getPTN_SCRIPT_NAME();
        result = result * 59 + ($PTN_SCRIPT_NAME == null ? 43 : $PTN_SCRIPT_NAME.hashCode());
        String $module = this.getModule();
        result = result * 59 + ($module == null ? 43 : $module.hashCode());
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        File $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public String toString() {
        return "SQLScriptBo(PTN_SCRIPT_NAME=" + this.getPTN_SCRIPT_NAME() + ", module=" + this.getModule() + ", fileName=" + this.getFileName() + ", file=" + this.getFile() + ", majorVersion=" + this.getMajorVersion() + ", minorVersion=" + this.getMinorVersion() + ", patchVersion=" + this.getPatchVersion() + ", version=" + this.getVersion() + ", description=" + this.getDescription() + ")";
    }
}

