/*
 * Decompiled with CFR 0.152.
 */
package website.dachuan.migration;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import website.dachuan.migration.MigrationProcess;
import website.dachuan.migration.props.MigrationProps;
import website.dachuan.migration.service.IDBOperation;
import website.dachuan.migration.service.ISchemaHistoryService;
import website.dachuan.migration.service.ISqlScriptRunner;
import website.dachuan.migration.utils.DatabaseIdProvider;

public class MigrationRun {
    private static final Logger log = LoggerFactory.getLogger(MigrationRun.class);
    private final MigrationProcess process;

    public MigrationRun(MigrationProps props, ISchemaHistoryService schemaHistoryService, ISqlScriptRunner scriptRunner, Map<String, IDBOperation> idbOperationMap) {
        this.process = new MigrationProcess(props, idbOperationMap, scriptRunner, schemaHistoryService);
    }

    public void run(DataSource dataSource, List<String> tenantIds) {
        DatabaseIdProvider.DatabaseId databaseId;
        Connection conn;
        try {
            conn = dataSource.getConnection();
            String databaseProductName = DatabaseIdProvider.getDatabaseId(conn);
            databaseId = DatabaseIdProvider.DatabaseId.valueOf(databaseProductName);
        }
        catch (SQLException e) {
            log.error("", (Throwable)e);
            return;
        }
        try {
            if (databaseId.ddlTransaction) {
                conn.setAutoCommit(false);
            }
            this.process.exec(conn, tenantIds);
            if (databaseId.ddlTransaction) {
                conn.commit();
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            try {
                if (databaseId.ddlTransaction) {
                    conn.rollback();
                }
                conn.close();
            }
            catch (SQLException sqlException) {
                log.error("", (Throwable)sqlException);
            }
            System.exit(0);
        }
    }
}

