/*
 * Decompiled with CFR 0.152.
 */
package website.dachuan.migration;

import java.io.IOException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.sf.jsqlparser.JSQLParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import website.dachuan.migration.entity.SchemaHistoryEntity;
import website.dachuan.migration.props.MigrationProps;
import website.dachuan.migration.service.IDBOperation;
import website.dachuan.migration.service.ISchemaHistoryService;
import website.dachuan.migration.service.ISqlScriptRunner;
import website.dachuan.migration.service.MigrationTask;
import website.dachuan.migration.service.task.CreateHistoryTableTask;
import website.dachuan.migration.service.task.DeployInitTableTask;
import website.dachuan.migration.service.task.IncreaseVersionTask;
import website.dachuan.migration.service.task.InsertBaselineTask;
import website.dachuan.migration.service.task.TenantDataInitScriptTask;
import website.dachuan.migration.service.task.TenantDataScriptTask;
import website.dachuan.migration.utils.DatabaseIdProvider;
import website.dachuan.migration.utils.SqlScriptCommon;

class MigrationProcess {
    private static final Logger log = LoggerFactory.getLogger(MigrationProcess.class);
    private final MigrationProps props;
    private final Map<String, IDBOperation> dbOperations;
    private final ISqlScriptRunner scriptRunner;
    private final ISchemaHistoryService schemaHistoryService;
    private final BlockingQueue<MigrationTask> tasks = new LinkedBlockingQueue<MigrationTask>();

    public MigrationProcess(MigrationProps props, Map<String, IDBOperation> dbOperations, ISqlScriptRunner scriptRunner, ISchemaHistoryService schemaHistoryService) {
        this.props = props;
        this.dbOperations = dbOperations;
        this.scriptRunner = scriptRunner;
        this.schemaHistoryService = schemaHistoryService;
    }

    public void exec(Connection conn, List<String> tenantIds) throws SQLException, JSQLParserException, IOException, NoSuchAlgorithmException {
        IDBOperation dbOperation = this.dbOperations.get(DatabaseIdProvider.getDatabaseId(conn));
        if (dbOperation == null) {
            throw new InvalidParameterException("DBOperation \u5b9e\u73b0\u7c7b\u672a\u53d1\u73b0\uff01");
        }
        OperationMode operationMode = this.chargeOperationMode(conn);
        assert (operationMode != null);
        this.assemblyTaskChain(operationMode, tenantIds);
        while (!this.tasks.isEmpty()) {
            ((MigrationTask)this.tasks.poll()).doTask(conn);
        }
    }

    private void assemblyTaskChain(OperationMode operationMode, List<String> tenantIds) {
        switch (operationMode) {
            case DEPLOY_INIT: {
                this.tasks.add(new CreateHistoryTableTask(this.props, this.scriptRunner));
                this.tasks.add(new DeployInitTableTask(this.props, new SqlScriptCommon(this.props, this.schemaHistoryService, this.scriptRunner)));
                if (this.props.getTenantData().isEnabled() && tenantIds != null && !tenantIds.isEmpty()) {
                    for (String tenantId : tenantIds) {
                        this.tasks.add(new TenantDataInitScriptTask(this.props, new SqlScriptCommon(this.props, this.schemaHistoryService, this.scriptRunner), tenantId));
                    }
                }
                this.tasks.add(new InsertBaselineTask(this.props, this.schemaHistoryService));
                break;
            }
            case BASELINE_CREATE: {
                this.tasks.add(new CreateHistoryTableTask(this.props, this.scriptRunner));
                this.tasks.add(new InsertBaselineTask(this.props, this.schemaHistoryService));
                break;
            }
            case BASELINE_INIT: {
                this.tasks.add(new InsertBaselineTask(this.props, this.schemaHistoryService));
                break;
            }
        }
        this.tasks.add(new IncreaseVersionTask(this.props, new SqlScriptCommon(this.props, this.schemaHistoryService, this.scriptRunner)));
        if (this.props.getTenantData().isEnabled() && tenantIds != null && !tenantIds.isEmpty()) {
            for (String tenantId : tenantIds) {
                this.tasks.add(new TenantDataScriptTask(this.props, new SqlScriptCommon(this.props, this.schemaHistoryService, this.scriptRunner), tenantId));
            }
        }
    }

    private OperationMode chargeOperationMode(Connection conn) throws SQLException {
        List<String> tbNames = this.dbOperations.get(DatabaseIdProvider.getDatabaseId(conn)).listTables(conn);
        if (tbNames.size() == 0) {
            return OperationMode.DEPLOY_INIT;
        }
        if (tbNames.stream().noneMatch(this.props.getSchemaHistoryTableName()::equals)) {
            return OperationMode.BASELINE_CREATE;
        }
        List<SchemaHistoryEntity> historyEntity = this.schemaHistoryService.queryLastVersion(conn, this.props);
        if (historyEntity == null || historyEntity.size() == 0) {
            return OperationMode.BASELINE_INIT;
        }
        return OperationMode.DEPLOY_INCREASE;
    }

    public static enum OperationMode {
        DEPLOY_INIT,
        DEPLOY_INCREASE,
        BASELINE_CREATE,
        BASELINE_INIT;

    }
}

