package website.dachuan.migration.service.postgresql;

import website.dachuan.migration.dao.postgresql.PostgreSQLDBOperationDao;
import website.dachuan.migration.service.IDBOperation;
import website.dachuan.migration.utils.DatabaseIdProvider;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class PostgreSQLDBOperation implements IDBOperation {
    private final PostgreSQLDBOperationDao operationDao;

    public PostgreSQLDBOperation(PostgreSQLDBOperationDao operationDao) {
        this.operationDao = operationDao;
    }

    @Override
    public String key() {
        return DatabaseIdProvider.DatabaseId.PostgreSQL.name();
    }

    @Override
    public List<String> listTables(Connection conn) throws SQLException {
        return operationDao.listTables(conn);
    }

    @Override
    public List<Map<String, String>> listColumn(Connection conn, String tableName) throws SQLException {
        return null;
    }
}
