package website.dachuan.migration;

import lombok.extern.slf4j.Slf4j;
import website.dachuan.migration.props.MigrationProps;
import website.dachuan.migration.service.IDBOperation;
import website.dachuan.migration.service.ISchemaHistoryService;
import website.dachuan.migration.service.ISqlScriptRunner;
import website.dachuan.migration.utils.DatabaseIdProvider;

import javax.sql.DataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

@Slf4j
public class MigrationRun {
    private final MigrationProcess process;

    public MigrationRun(MigrationProps props, ISchemaHistoryService schemaHistoryService, ISqlScriptRunner scriptRunner, Map<String, IDBOperation> idbOperationMap) {
        process = new MigrationProcess(props, idbOperationMap, scriptRunner, schemaHistoryService);
    }

    /**
     * 当前数据源脚本自动升级
     *
     * @param dataSource 数据源
     * @param tenantIds  租户ID
     */
    public void run(DataSource dataSource, List<String> tenantIds) {
        Connection conn;
        DatabaseIdProvider.DatabaseId databaseId;
        try {
            conn = dataSource.getConnection();
            String databaseProductName = DatabaseIdProvider.getDatabaseId(conn);
            databaseId = DatabaseIdProvider.DatabaseId.valueOf(databaseProductName);
        } catch (SQLException e) {
            log.error("", e);
            return;
        }
        try {
            if (databaseId.ddlTransaction) {
                conn.setAutoCommit(false);
            }
            process.exec(conn, tenantIds);
            if (databaseId.ddlTransaction) {
                conn.commit();
            }
        } catch (Exception e) {
            log.error("", e);
            try {
                if (databaseId.ddlTransaction) {
                    conn.rollback();
                }
                conn.close();
            } catch (SQLException sqlException) {
                log.error("", sqlException);
            }
            System.exit(0);
        }
    }
}
