package website.dachuan.migration.utils;

import lombok.extern.slf4j.Slf4j;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Optional;

@Slf4j
public class DatabaseIdProvider {
    public enum DatabaseId {
        MySQL("mysql", false),
        PostgreSQL("postgresql", true),
        HighGo("highgo", true),
        NnKnown("unknown", false);
        public final String uk;
        public final boolean ddlTransaction;

        DatabaseId(String uk, boolean ddlTransaction) {
            this.uk = uk;
            this.ddlTransaction = ddlTransaction;
        }

        static DatabaseId uk(String uk) {
            Optional<DatabaseId> r = Arrays.stream(DatabaseId.values()).filter(databaseId -> databaseId.uk.equals(uk)).findFirst();
            return r.orElse(NnKnown);
        }
    }

    public static String getDatabaseId(Connection connection) {
        if (connection == null) {
            throw new NullPointerException("DatabaseIdProvider connection cannot be null");
        } else {
            try {
                String productName = connection.getMetaData().getDatabaseProductName();
                String url = connection.getMetaData().getURL();
                if (url.toLowerCase().contains(productName.toLowerCase())) {
                    return DatabaseId.valueOf(productName).name();
                } else {
                    String[] urls = url.split(":");
                    return DatabaseId.uk(urls[1]).name();
                }
            } catch (SQLException e) {
                log.error(log.getName(), e);
                return DatabaseId.NnKnown.name();
            }
        }
    }
}
