package website.dachuan.migration.service.highgo;

import website.dachuan.migration.dao.postgresql.PostgreSQLDBOperationDao;
import website.dachuan.migration.service.IDBOperation;
import website.dachuan.migration.utils.DatabaseIdProvider;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class HighGoDBOperation implements IDBOperation {
    private final PostgreSQLDBOperationDao operationDao;

    public HighGoDBOperation(PostgreSQLDBOperationDao operationDao) {
        this.operationDao = operationDao;
    }

    @Override
    public String key() {
        return DatabaseIdProvider.DatabaseId.HighGo.name();
    }

    @Override
    public List<String> listTables(Connection conn) throws SQLException {
        return operationDao.listTables(conn);
    }

    @Override
    public List<Map<String, String>> listColumn(Connection conn, String tableName) throws SQLException {
        return null;
    }
}
