package website.dachuan.migration.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

/**
 * 读取sql文件
 *
 * @author qingbin
 */
public class SqlScriptReader {

    /**
     * 读取SQL脚本文件
     *
     * @param reader sql文件输入流
     * @return SQL语句集合
     */
    public static List<String> readSqlScript(Reader reader) {
        List<String> sqlScript = new ArrayList<>();
        try (BufferedReader br = new BufferedReader(reader)) {
            // 生成sql构造器
            StringBuilder sqlBuilder = new StringBuilder();
            String line;
            while ((line = br.readLine()) != null) {
                // 去除首位空白字符
                line = line.trim();
                // 去除空行、注释行
                if (line.length() == 0 || line.startsWith("--")) {
                    continue;
                }
                if (line.endsWith(";")) {
                    // 如果该行以";"结尾，则认为该条sql语句结束
                    sqlBuilder.append(line);
                    // 将sql构造器转为sql语句，加入sql语句集合
                    sqlScript.add(sqlBuilder.toString());
                    // 清空sql构造器
                    sqlBuilder.delete(0, sqlBuilder.length());
                } else {
                    // 如果该行没有以";"结尾，则认为该条sql语句尚未结束
                    sqlBuilder.append(line).append(" \n");
                }
            }
            // 特殊场景处理：如果sql脚本最后一条sql语句没有写";"结尾，则需要将非空的sql构造器转为sql语句并加入sql语句集合。
            if (sqlBuilder.length() > 0) {
                sqlBuilder.append(";");
                sqlScript.add(sqlBuilder.toString());
                sqlBuilder.delete(0, sqlBuilder.length());
            }
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sqlScript;
    }
}
