package website.dachuan.migration.service;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.dbutils.QueryRunner;
import website.dachuan.migration.utils.SqlScriptReader;

import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

@Slf4j
public class SqlScriptRunner implements ISqlScriptRunner {
    private final QueryRunner runner;

    public SqlScriptRunner() {
        this.runner = new QueryRunner();

    }

    @Override
    public Integer runScript(Connection conn, Reader reader) throws SQLException {
        List<String> sqlList = SqlScriptReader.readSqlScript(reader);
        for (String sql : sqlList) {
            runner.update(conn, sql);
        }
        return 1;
    }
}
