package website.dachuan.migration.dao.postgresql;

import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.handlers.ColumnListHandler;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;


public class PostgreSQLDBOperationDao {

    private final QueryRunner queryRunner;

    public PostgreSQLDBOperationDao() {
        this.queryRunner = new QueryRunner();
    }

    public List<String> listTables(Connection conn) throws SQLException {
        String listTablesSql = "SELECT tablename FROM pg_tables pt where schemaname = (select  current_schema());";
        return queryRunner.query(conn, listTablesSql, new ColumnListHandler<>(1));
    }
}
