/*
 * Decompiled with CFR 0.152.
 */
package website.automate.teamcity.agent.support;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import website.automate.teamcity.agent.support.ContextParameterResolver;

public class BuildProcessConfig {
    private static final long DEFAULT_EXECUTION_TIMEOUT_IN_SEC = 300L;
    private static final long DEFAULT_JOB_STATUS_CHECK_INTERVAL_IN_SEC = 30L;
    private long executionTimeoutSec;
    private long jobStatusCheckIntervalSec;
    private String username;
    private String password;
    private List<String> scenarioIds;
    private Map<String, String> context;

    public static BuildProcessConfig of(Map<String, String> runnerParameters, Map<String, String> configParameters) {
        String username = runnerParameters.get("website.automate.teamcity.account.username");
        String password = runnerParameters.get("website.automate.teamcity.account.password");
        String scenarioIdsStr = runnerParameters.get("website.automate.teamcity.selectedScenarios");
        long executionTimeoutSec = BuildProcessConfig.getParamValueAsLong(configParameters, "website.automate.executionTimeoutSec", 300L);
        long jobStatusCheckIntervalSec = BuildProcessConfig.getParamValueAsLong(configParameters, "website.automate.jobStatusCheckIntervalSec", 30L);
        Map<String, String> context = ContextParameterResolver.getInstance().resolve(configParameters);
        List<String> scenarioIds = Arrays.asList(scenarioIdsStr.split(","));
        return new BuildProcessConfig(username, password, scenarioIds, context, executionTimeoutSec, jobStatusCheckIntervalSec);
    }

    private static long getParamValueAsLong(Map<String, String> configParameters, String paramName, long defaultValue) {
        return Long.parseLong(BuildProcessConfig.getOrDefault(configParameters, paramName, Long.toString(defaultValue)));
    }

    private static String getOrDefault(Map<String, String> map, String key, String defaultValue) {
        String value = map.get(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    private BuildProcessConfig(String username, String password, List<String> scenarioIds, Map<String, String> context, long executionTimeoutSec, long jobStatusCheckIntervalSec) {
        this.username = username;
        this.password = password;
        this.scenarioIds = scenarioIds;
        this.context = context;
        this.executionTimeoutSec = executionTimeoutSec;
        this.jobStatusCheckIntervalSec = jobStatusCheckIntervalSec;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public List<String> getScenarioIds() {
        return this.scenarioIds;
    }

    public Map<String, String> getContext() {
        return this.context;
    }

    public long getExecutionTimeoutSec() {
        return this.executionTimeoutSec;
    }

    public long getJobStatusCheckIntervalSec() {
        return this.jobStatusCheckIntervalSec;
    }
}

