/*
 * Decompiled with CFR 0.152.
 */
package website.automate.teamcity.agent.support;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class BuildProcessConfig {
    private String username;
    private String password;
    private List<String> scenarioIds;

    public static BuildProcessConfig of(Map<String, String> runnerParameters) {
        String username = runnerParameters.get("website.automate.teamcity.account.username");
        String password = runnerParameters.get("website.automate.teamcity.account.password");
        String scenarioIdsStr = runnerParameters.get("website.automate.teamcity.selectedScenarios");
        List<String> scenarioIds = Arrays.asList(scenarioIdsStr.split(","));
        return new BuildProcessConfig(username, password, scenarioIds);
    }

    private BuildProcessConfig(String username, String password, List<String> scenarioIds) {
        this.username = username;
        this.password = password;
        this.scenarioIds = scenarioIds;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public List<String> getScenarioIds() {
        return this.scenarioIds;
    }
}

