/*
 * Decompiled with CFR 0.152.
 */
package website.automate.teamcity.agent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.buildServer.RunBuildException;
import jetbrains.buildServer.agent.BuildFinishedStatus;
import jetbrains.buildServer.agent.BuildProcess;
import jetbrains.buildServer.agent.BuildProgressLogger;
import website.automate.manager.api.client.JobManagementRemoteService;
import website.automate.manager.api.client.model.Authentication;
import website.automate.manager.api.client.model.Job;
import website.automate.manager.api.client.model.TestResults;
import website.automate.manager.api.client.support.Constants;
import website.automate.teamcity.agent.support.BuildProcessConfig;
import website.automate.teamcity.agent.support.ExecutionInterruptionException;

public class AutomateWebsiteBuildProcess
implements BuildProcess {
    private static final long DEFAULT_JOB_STATUS_CHECK_INTERVAL_IN_SEC = 30L;
    private static final long DEFAULT_EXECUTION_TIMEOUT_IN_SEC = 300L;
    private JobManagementRemoteService jobManagementRemoteService = JobManagementRemoteService.getInstance();
    private long jobStatusCheckIntervalInSec = 30L;
    private long executionTimeoutInSec = 300L;
    private BuildProcessConfig config;
    private BuildFinishedStatus status;
    private BuildProgressLogger logger;

    public AutomateWebsiteBuildProcess(BuildProcessConfig config, BuildProgressLogger logger) {
        this.config = config;
        this.logger = logger;
    }

    public void start() throws RunBuildException {
        List updatedJobs;
        List<String> scenarioIds = this.config.getScenarioIds();
        Authentication principal = Authentication.of((String)this.config.getUsername(), (String)this.config.getPassword());
        if (scenarioIds == null || scenarioIds.isEmpty()) {
            this.logger.message("Skipping execution - no scenarios were selected.");
            this.status = BuildFinishedStatus.FINISHED_SUCCESS;
            return;
        }
        this.logger.message(String.format("Creating jobs for selected scenarios %s ...", scenarioIds));
        List createdJobs = this.jobManagementRemoteService.createJobs(this.createJobs(scenarioIds), principal);
        long jobsCreatedMillis = System.currentTimeMillis();
        Collection<String> createdJobIds = this.asJobIds(createdJobs);
        while (System.currentTimeMillis() - jobsCreatedMillis < this.executionTimeoutInSec * 1000L) {
            try {
                Thread.sleep(this.jobStatusCheckIntervalInSec * 1000L);
            }
            catch (InterruptedException e) {
                throw new ExecutionInterruptionException("Unexpected plugin execution thread interrupt occured.", e);
            }
            this.logger.message("Checking job statuses ...");
            updatedJobs = this.jobManagementRemoteService.getJobsByIdsAndPrincipal(createdJobIds, principal, Job.JobProfile.BRIEF);
            if (!this.areCompleted(updatedJobs)) continue;
        }
        this.logger.message("Jobs execution completed.");
        updatedJobs = this.jobManagementRemoteService.getJobsByIdsAndPrincipal(createdJobIds, principal, Job.JobProfile.COMPLETE);
        this.status = this.logJobStatuses(updatedJobs);
    }

    private BuildFinishedStatus logJobStatuses(Collection<Job> jobs) {
        BuildFinishedStatus result = BuildFinishedStatus.FINISHED_SUCCESS;
        for (Job job : jobs) {
            String jobTitle = job.getTitle();
            TestResults testResults = job.getTestResults();
            String jobUrl = this.getJobUrl(job.getId());
            if (testResults != null) {
                if (!testResults.isFailed()) {
                    this.logger.message(String.format("%s job execution succeeded (%s).", jobTitle, jobUrl));
                    continue;
                }
                if (result != BuildFinishedStatus.FINISHED_FAILED) {
                    result = BuildFinishedStatus.FINISHED_WITH_PROBLEMS;
                }
                this.logger.warning(String.format("%s job execution failed (%s).", jobTitle, jobUrl));
                continue;
            }
            result = BuildFinishedStatus.FINISHED_FAILED;
            this.logger.warning(String.format("Unexpected error occured during execution of '%s' or execution took to long (%s).", jobTitle, jobUrl));
        }
        return result;
    }

    private String getJobUrl(String jobId) {
        return Constants.getAppBaseUrl() + "/job/" + jobId;
    }

    private boolean areCompleted(Collection<Job> jobs) {
        for (Job job : jobs) {
            Job.JobStatus jobStatus = job.getStatus();
            if (jobStatus != Job.JobStatus.SCHEDULED && jobStatus != Job.JobStatus.RUNNING) continue;
            return false;
        }
        return true;
    }

    private Collection<String> asJobIds(Collection<Job> jobs) {
        ArrayList<String> jobIds = new ArrayList<String>();
        for (Job job : jobs) {
            jobIds.add(job.getId());
        }
        return jobIds;
    }

    private Collection<Job> createJobs(Collection<String> scenarioIds) {
        ArrayList<Job> jobs = new ArrayList<Job>();
        for (String scenarioId : scenarioIds) {
            jobs.add(this.createJob(scenarioId));
        }
        return jobs;
    }

    private Job createJob(String scenarioId) {
        Job job = new Job();
        job.setScenarioId(scenarioId);
        job.setTakeScreenshots(Job.TakeScreenshots.ON_FAILURE);
        return job;
    }

    public boolean isInterrupted() {
        return false;
    }

    public boolean isFinished() {
        return this.status != null;
    }

    public void interrupt() {
    }

    public BuildFinishedStatus waitFor() throws RunBuildException {
        return this.status;
    }
}

