/*
 * Decompiled with CFR 0.152.
 */
package website.automate.jenkins.support;

import java.util.Map;
import website.automate.jenkins.service.JobConfigResolver;
import website.automate.jenkins.support.JobConfig;

public class BuildConfig {
    public static final String PROPERTY_NAME_EXECUTION_TIMEOUT_SEC = "website.automate.executionTimeoutSec";
    public static final String PROPERTY_NAME_JOB_STATUS_CHECK_INTERVAL_SEC = "website.automate.jobStatusCheckIntervalSec";
    private static final long DEFAULT_EXECUTION_TIMEOUT_IN_SEC = 300L;
    private static final long DEFAULT_JOB_STATUS_CHECK_INTERVAL_IN_SEC = 30L;
    private long executionTimeoutSec;
    private long jobStatusCheckIntervalSec;
    private JobConfig jobConfig;

    public BuildConfig(Map<String, String> configParameters) {
        this.executionTimeoutSec = BuildConfig.getParamValueAsLong(configParameters, PROPERTY_NAME_EXECUTION_TIMEOUT_SEC, 300L);
        this.jobStatusCheckIntervalSec = BuildConfig.getParamValueAsLong(configParameters, PROPERTY_NAME_JOB_STATUS_CHECK_INTERVAL_SEC, 30L);
        this.jobConfig = JobConfigResolver.getInstance().resolve(configParameters);
    }

    public long getExecutionTimeoutSec() {
        return this.executionTimeoutSec;
    }

    public long getJobStatusCheckIntervalSec() {
        return this.jobStatusCheckIntervalSec;
    }

    public JobConfig getJobConfig() {
        return this.jobConfig;
    }

    private static long getParamValueAsLong(Map<String, String> configParameters, String paramName, long defaultValue) {
        return Long.parseLong(BuildConfig.getOrDefault(configParameters, paramName, Long.toString(defaultValue)));
    }

    private static String getOrDefault(Map<String, String> map, String key, String defaultValue) {
        String value = map.get(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }
}

