/*
 * Decompiled with CFR 0.152.
 */
package website.automate.jenkins;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import hudson.EnvVars;
import hudson.Launcher;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Items;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.Builder;
import java.util.Arrays;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;
import website.automate.jenkins.AutomateWebsiteDescriptor;
import website.automate.jenkins.logging.BuilderLogHandler;
import website.automate.jenkins.service.PluginExecutionService;
import website.automate.jenkins.support.BuildConfig;

@XStreamAlias(value="automate-website-builder")
public class AutomateWebsiteBuilder
extends Builder {
    public static final String BUILDER_TITLE = "Automate Website Execution";
    private final String project;
    private String scenario;

    @DataBoundConstructor
    public AutomateWebsiteBuilder(String project, String scenario) {
        this.project = project;
        this.scenario = scenario;
    }

    @Initializer(before=InitMilestone.PLUGINS_STARTED)
    public static void addAliases() {
        Items.XSTREAM2.processAnnotations(new Class[]{AutomateWebsiteBuilder.class});
    }

    public String getProject() {
        return this.project;
    }

    public String getScenario() {
        return this.scenario;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        PluginExecutionService pluginExecutionService = PluginExecutionService.getInstance();
        EnvVars envVars = this.getEnvironmentVariables(build, listener);
        Result result = pluginExecutionService.execute(new BuildConfig((Map<String, String>)envVars), Arrays.asList(this.getScenarioId()), this.getDescriptor().getAuthentication(), BuilderLogHandler.getInstance(listener.getLogger()));
        build.setResult(result);
        return true;
    }

    private EnvVars getEnvironmentVariables(AbstractBuild build, BuildListener listener) {
        try {
            return build.getEnvironment((TaskListener)listener);
        }
        catch (Exception e) {
            return new EnvVars();
        }
    }

    private String getScenarioId() {
        String scenario = this.getScenario();
        if (scenario == null) {
            return null;
        }
        return scenario.split(":")[1];
    }

    public AutomateWebsiteDescriptor getDescriptor() {
        return (AutomateWebsiteDescriptor)super.getDescriptor();
    }
}

