/*
 * Decompiled with CFR 0.152.
 */
package website.automate.jenkins;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Items;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import website.automate.jenkins.logging.BuilderLogHandler;
import website.automate.jenkins.mapper.ProjectMapper;
import website.automate.jenkins.model.ProjectSerializable;
import website.automate.jenkins.model.ScenarioSerializable;
import website.automate.jenkins.service.PluginExecutionService;
import website.automate.jenkins.support.BuildConfig;
import website.automate.manager.api.client.ProjectRetrievalRemoteService;
import website.automate.manager.api.client.model.Authentication;
import website.automate.manager.api.client.support.CommunicationException;

public class AutomateWebsiteBuilder
extends Builder {
    public static final String BUILDER_TITLE = "Automate Website Execution";
    private final String project;
    private String scenario;

    @DataBoundConstructor
    public AutomateWebsiteBuilder(String project, String scenario) {
        this.project = project;
        this.scenario = scenario;
    }

    public String getProject() {
        return this.project;
    }

    public String getScenario() {
        return this.scenario;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        PluginExecutionService pluginExecutionService = PluginExecutionService.getInstance();
        EnvVars envVars = this.getEnvironmentVariables(build, listener);
        Result result = pluginExecutionService.execute(new BuildConfig((Map<String, String>)envVars), Arrays.asList(this.getScenarioId()), this.getDescriptor().getAuthentication(), BuilderLogHandler.getInstance(listener.getLogger()));
        build.setResult(result);
        return true;
    }

    private EnvVars getEnvironmentVariables(AbstractBuild build, BuildListener listener) {
        try {
            return build.getEnvironment((TaskListener)listener);
        }
        catch (Exception e) {
            return new EnvVars();
        }
    }

    private String getScenarioId() {
        String scenario = this.getScenario();
        if (scenario == null) {
            return null;
        }
        return scenario.split(":")[1];
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    @XStreamAlias(value="descriptor")
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private static final ProjectMapper PROJECT_MAPPER = ProjectMapper.getInstance();
        private String username;
        private String password;
        private List<ProjectSerializable> projects;

        @Initializer(before=InitMilestone.PLUGINS_STARTED)
        public static void addAliases() {
            Items.XSTREAM2.processAnnotations(new Class[]{ProjectSerializable.class, ScenarioSerializable.class});
        }

        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return AutomateWebsiteBuilder.BUILDER_TITLE;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.configureIfRequired(this.username, this.password);
            return super.configure(req, formData);
        }

        public FormValidation doSyncProjects(@QueryParameter(value="username") String username, @QueryParameter(value="password") String password) throws IOException, ServletException {
            try {
                this.configure(username, password);
                return FormValidation.ok((String)"Success");
            }
            catch (CommunicationException e) {
                return FormValidation.error((String)("Client error : " + e.getMessage()));
            }
        }

        private void configureIfRequired(String newUsername, String newPassword) {
            this.configure(newUsername, newPassword, false);
        }

        private void configure(String newUsername, String newPassword) {
            this.configure(newUsername, newPassword, true);
        }

        public Authentication getAuthentication() {
            return Authentication.of((String)this.username, (String)this.password);
        }

        private void configure(String newUsername, String newPassword, boolean forceProjectSync) {
            String username = this.getUsername();
            String password = this.getPassword();
            if (!newUsername.equals(username) || !newPassword.equals(password) || forceProjectSync) {
                this.setUsername(newUsername);
                this.setPassword(newPassword);
                List<ProjectSerializable> projects = this.retrieveAndMapProjects(newUsername, newPassword);
                this.setProjects(projects);
                this.save();
            }
        }

        private List<ProjectSerializable> retrieveAndMapProjects(String username, String password) {
            List projects = ProjectRetrievalRemoteService.getInstance().getProjectsWithExecutableScenariosByPrincipal(Authentication.of((String)username, (String)password));
            return PROJECT_MAPPER.safeMapList(projects);
        }

        public ListBoxModel doFillProjectItems() {
            List<ProjectSerializable> projects = this.getProjects();
            ListBoxModel items = new ListBoxModel();
            for (ProjectSerializable project : projects) {
                items.add(project.getTitle(), project.getId());
            }
            return items;
        }

        public ListBoxModel doFillScenarioItems(@QueryParameter(value="project") String projectId) {
            ListBoxModel items = new ListBoxModel();
            if (projectId == null || projectId.isEmpty()) {
                return items;
            }
            ProjectSerializable project = this.getProjectById(projectId);
            List<ScenarioSerializable> scenarios = project.getScenarios();
            if (scenarios == null) {
                return items;
            }
            for (ScenarioSerializable scenario : scenarios) {
                items.add(scenario.getName(), this.asComboId(projectId, scenario.getId()));
            }
            return items;
        }

        private String asComboId(String projectId, String scenarioId) {
            return projectId + ":" + scenarioId;
        }

        private ProjectSerializable getProjectById(String projectId) {
            List<ProjectSerializable> projects = this.getProjects();
            for (ProjectSerializable project : projects) {
                if (!project.getId().equals(projectId)) continue;
                return project;
            }
            return null;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        private List<ProjectSerializable> getProjects() {
            return this.projects;
        }

        private void setProjects(List<ProjectSerializable> projects) {
            this.projects = projects;
        }
    }
}

