/*
 * Decompiled with CFR 0.152.
 */
package website.automate.jenkins.service;

import hudson.model.Result;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Logger;
import website.automate.jenkins.support.ExecutionInterruptionException;
import website.automate.manager.api.client.JobManagementRemoteService;
import website.automate.manager.api.client.model.Authentication;
import website.automate.manager.api.client.model.Job;
import website.automate.manager.api.client.model.TestResults;
import website.automate.manager.api.client.support.Constants;

public class PluginExecutionService {
    private static final PluginExecutionService INSTANCE = new PluginExecutionService();
    private static final long DEFAULT_JOB_STATUS_CHECK_INTERVAL_IN_SEC = 30L;
    private static final long DEFAULT_EXECUTION_TIMEOUT_IN_SEC = 300L;
    private static final Logger LOGGER = Logger.getLogger(PluginExecutionService.class.getSimpleName());
    private JobManagementRemoteService jobManagementRemoteService = JobManagementRemoteService.getInstance();
    private long jobStatusCheckIntervalInSec = 30L;
    private long executionTimeoutInSec = 300L;

    public static PluginExecutionService getInstance() {
        return INSTANCE;
    }

    public Result execute(Collection<String> scenarioIds, Authentication principal, Handler handler) {
        List updatedJobs;
        LOGGER.addHandler(handler);
        if (scenarioIds == null || scenarioIds.isEmpty()) {
            LOGGER.info("Skipping execution - no scenarios were selected.");
            return Result.SUCCESS;
        }
        LOGGER.info(String.format("Creating jobs for selected scenarios %s ...", scenarioIds));
        List createdJobs = this.jobManagementRemoteService.createJobs(this.createJobs(scenarioIds), principal);
        long jobsCreatedMillis = System.currentTimeMillis();
        Collection<String> createdJobIds = this.asJobIds(createdJobs);
        while (System.currentTimeMillis() - jobsCreatedMillis < this.executionTimeoutInSec * 1000L) {
            try {
                Thread.sleep(this.jobStatusCheckIntervalInSec * 1000L);
            }
            catch (InterruptedException e) {
                throw new ExecutionInterruptionException("Unexpected plugin execution thread interrupt occured.", e);
            }
            LOGGER.info("Checking job statuses ...");
            updatedJobs = this.jobManagementRemoteService.getJobsByIdsAndPrincipal(createdJobIds, principal, Job.JobProfile.BRIEF);
            if (!this.areCompleted(updatedJobs)) continue;
        }
        LOGGER.info("Jobs execution completed.");
        updatedJobs = this.jobManagementRemoteService.getJobsByIdsAndPrincipal(createdJobIds, principal, Job.JobProfile.COMPLETE);
        Result result = this.logJobStatuses(updatedJobs);
        LOGGER.removeHandler(handler);
        return result;
    }

    private Result logJobStatuses(Collection<Job> jobs) {
        Result result = Result.SUCCESS;
        for (Job job : jobs) {
            String jobTitle = job.getTitle();
            TestResults testResults = job.getTestResults();
            String jobUrl = this.getJobUrl(job.getId());
            if (testResults != null) {
                if (!testResults.isFailed()) {
                    LOGGER.info(String.format("%s job execution succeeded (%s).", jobTitle, jobUrl));
                    continue;
                }
                if (result != Result.FAILURE) {
                    result = Result.UNSTABLE;
                }
                LOGGER.severe(String.format("%s job execution failed (%s).", jobTitle, jobUrl));
                continue;
            }
            result = Result.FAILURE;
            LOGGER.severe(String.format("Unexpected error occured during execution of '%s' or execution took to long (%s).", jobTitle, jobUrl));
        }
        return result;
    }

    private String getJobUrl(String jobId) {
        return Constants.getAppBaseUrl() + "/job/" + jobId;
    }

    private boolean areCompleted(Collection<Job> jobs) {
        for (Job job : jobs) {
            Job.JobStatus jobStatus = job.getStatus();
            if (jobStatus != Job.JobStatus.SCHEDULED && jobStatus != Job.JobStatus.RUNNING) continue;
            return false;
        }
        return true;
    }

    private Collection<String> asJobIds(Collection<Job> jobs) {
        ArrayList<String> jobIds = new ArrayList<String>();
        for (Job job : jobs) {
            jobIds.add(job.getId());
        }
        return jobIds;
    }

    private Collection<Job> createJobs(Collection<String> scenarioIds) {
        ArrayList<Job> jobs = new ArrayList<Job>();
        for (String scenarioId : scenarioIds) {
            jobs.add(this.createJob(scenarioId));
        }
        return jobs;
    }

    private Job createJob(String scenarioId) {
        Job job = new Job();
        job.setScenarioId(scenarioId);
        job.setTakeScreenshots(Job.TakeScreenshots.ON_FAILURE);
        return job;
    }
}

