(ns peony.core
  (:require [peony.coll :as c])
  (:import [com.mongodb MongoClient MongoClientURI]))

(def ^:dynamic *cl* {})

(defn open [uri db cl] 
  (let [co# (MongoClient. (MongoClientURI. uri))
        db# (.getDB co# db)
        cl# (.getCollection db# cl)]
    {:co co# :db db# :cl cl#}))

(defn ++++ [doc] (c/++++ (:cl *cl*) doc))
(defn ---- [qry] (c/---- (:cl *cl*) qry))
(defn --id [id]  (c/--id (:cl *cl*) id))
(defn ???? [qry] (c/???? (:cl *cl*) qry))
(defn ??id [id]  (c/??id (:cl *cl*) id))
(defn ==== [qry doc] (c/==== (:cl *cl*) qry doc))
(defn ==id [id doc]  (c/==id (:cl *cl*) id doc))

(defmacro >>>> [cl & body] 
  `(do (let [cl# ~cl] (binding [*cl* cl#] ~@body))))
