/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import org.apache.log4j.Logger;
import voldemort.utils.impl.CommandOutputListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnixCommand {
    private final String hostName;
    private final String[] args;
    private static final Logger logger = Logger.getLogger(UnixCommand.class);

    public UnixCommand(String hostName, String ... args) {
        this.hostName = hostName;
        this.args = args;
    }

    public UnixCommand(String hostName, List<String> args) {
        this.hostName = hostName;
        this.args = args.toArray(new String[args.size()]);
    }

    public String getHostName() {
        return this.hostName;
    }

    public int execute(CommandOutputListener commandOutputListener) throws InterruptedException, IOException {
        ProcessBuilder builder = new ProcessBuilder(this.args);
        Process process = builder.start();
        ProcessOutputWatcher stdoutWatcher = new ProcessOutputWatcher(new BufferedReader(new InputStreamReader(process.getInputStream())), commandOutputListener);
        ProcessOutputWatcher stderrWatcher = new ProcessOutputWatcher(new BufferedReader(new InputStreamReader(process.getErrorStream())), commandOutputListener);
        stdoutWatcher.start();
        stderrWatcher.start();
        process.waitFor();
        return process.exitValue();
    }

    private class ProcessOutputWatcher
    extends Thread {
        private final BufferedReader reader;
        private final CommandOutputListener commandOutputListener;

        public ProcessOutputWatcher(BufferedReader reader, CommandOutputListener commandOutputListener) {
            this.reader = reader;
            this.commandOutputListener = commandOutputListener;
        }

        public void run() {
            try {
                String line = null;
                while ((line = this.reader.readLine()) != null) {
                    try {
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)line);
                        }
                        this.commandOutputListener.outputReceived(UnixCommand.this.hostName, line);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

