/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils.impl;

import com.xerox.amazonws.ec2.InstanceType;
import com.xerox.amazonws.ec2.Jec2;
import com.xerox.amazonws.ec2.LaunchConfiguration;
import com.xerox.amazonws.ec2.ReservationDescription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import voldemort.utils.Ec2Connection;
import voldemort.utils.Ec2ConnectionListener;
import voldemort.utils.HostNamePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypicaEc2Connection
implements Ec2Connection {
    private static final int POLL_INTERVAL = 15;
    private final Jec2 ec2;
    private final Ec2ConnectionListener listener;
    private final Log logger = LogFactory.getLog(this.getClass());

    public TypicaEc2Connection(String accessId, String secretKey) {
        this(accessId, secretKey, null);
    }

    public TypicaEc2Connection(String accessId, String secretKey, Ec2ConnectionListener listener) {
        this.ec2 = new Jec2(accessId, secretKey);
        this.listener = listener;
    }

    @Override
    public List<HostNamePair> list() throws Exception {
        ArrayList<HostNamePair> hostNamePairs = new ArrayList<HostNamePair>();
        for (ReservationDescription res : this.ec2.describeInstances(Collections.emptyList())) {
            if (res.getInstances() == null) continue;
            for (ReservationDescription.Instance instance : res.getInstances()) {
                HostNamePair hostNamePair = this.getHostNamePair(instance);
                if (hostNamePair == null) {
                    if (!this.logger.isWarnEnabled()) continue;
                    this.logger.warn((Object)("Instance " + instance.getInstanceId() + " present, but missing external and/or internal host name"));
                    continue;
                }
                hostNamePairs.add(hostNamePair);
            }
        }
        return hostNamePairs;
    }

    @Override
    public List<HostNamePair> createInstances(String ami, String keypairId, Ec2Connection.Ec2InstanceType instanceType, int instanceCount, List<String> securityGroups) throws Exception {
        LaunchConfiguration launchConfiguration = new LaunchConfiguration(ami);
        launchConfiguration.setInstanceType(InstanceType.valueOf((String)instanceType.name()));
        launchConfiguration.setKeyName(keypairId);
        launchConfiguration.setMinCount(instanceCount);
        launchConfiguration.setMaxCount(instanceCount);
        if (securityGroups != null && securityGroups.size() > 0) {
            launchConfiguration.setSecurityGroup(securityGroups);
        }
        ReservationDescription reservationDescription = this.ec2.runInstances(launchConfiguration);
        ArrayList<String> instanceIds = new ArrayList<String>();
        for (ReservationDescription.Instance instance : reservationDescription.getInstances()) {
            String instanceId = instance.getInstanceId();
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Instance " + instanceId + " launched"));
            }
            instanceIds.add(instanceId);
            if (this.listener == null) continue;
            this.listener.instanceCreated(instanceId);
        }
        ArrayList<HostNamePair> hostNamePairs = new ArrayList<HostNamePair>();
        while (!instanceIds.isEmpty()) {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Sleeping for 15 seconds...");
                }
                Thread.sleep(15000L);
            }
            catch (InterruptedException e) {
                break;
            }
            for (ReservationDescription res : this.ec2.describeInstances(instanceIds)) {
                if (res.getInstances() == null) continue;
                for (ReservationDescription.Instance instance : res.getInstances()) {
                    String state = String.valueOf(instance.getState()).toLowerCase();
                    if (!state.equals("running")) {
                        if (!this.logger.isDebugEnabled()) continue;
                        this.logger.debug((Object)("Instance " + instance.getInstanceId() + " in state: " + state));
                        continue;
                    }
                    HostNamePair hostNamePair = this.getHostNamePair(instance);
                    if (hostNamePair == null) {
                        if (!this.logger.isWarnEnabled()) continue;
                        this.logger.warn((Object)("Instance " + instance.getInstanceId() + " in running state, but missing external and/or internal host name"));
                        continue;
                    }
                    hostNamePairs.add(hostNamePair);
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info((Object)("Instance " + instance.getInstanceId() + " running with external host name: " + hostNamePair.getExternalHostName() + ", internal host name: " + hostNamePair.getInternalHostName()));
                    }
                    instanceIds.remove(instance.getInstanceId());
                }
            }
        }
        return hostNamePairs;
    }

    @Override
    public void deleteInstancesByHostName(List<String> hostNames) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Deleting instances for hosts: " + hostNames));
        }
        ArrayList<String> instanceIds = new ArrayList<String>();
        for (ReservationDescription res : this.ec2.describeInstances(Collections.emptyList())) {
            if (res.getInstances() == null) continue;
            for (ReservationDescription.Instance instance : res.getInstances()) {
                String externalHostName;
                String string = externalHostName = instance.getDnsName() != null ? instance.getDnsName().trim() : "";
                if (!hostNames.contains(externalHostName)) continue;
                String state = String.valueOf(instance.getState()).toLowerCase();
                String instanceId = instance.getInstanceId();
                if (state.equals("shutting-down") || state.equals("terminated")) {
                    if (!this.logger.isWarnEnabled()) continue;
                    this.logger.warn((Object)("Instance " + instanceId + " in state \"" + instance.getState() + "\" - ignoring"));
                    continue;
                }
                instanceIds.add(instanceId);
                if (!this.logger.isInfoEnabled()) continue;
                this.logger.info((Object)("Instance " + instanceId + " (" + externalHostName + ") to be terminated"));
            }
        }
        this.deleteInstancesByInstanceId(instanceIds);
    }

    @Override
    public void deleteInstancesByInstanceId(List<String> instanceIds) throws Exception {
        if (instanceIds.isEmpty()) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Deleting instances: " + instanceIds));
        }
        this.ec2.terminateInstances(instanceIds);
        int count = instanceIds.size();
        while (count > 0) {
            ReservationDescription res;
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Sleeping for 15 seconds...");
                }
                Thread.sleep(15000L);
            }
            catch (InterruptedException e) {
                break;
            }
            Iterator i$ = this.ec2.describeInstances(instanceIds).iterator();
            while (i$.hasNext() && (res = (ReservationDescription)i$.next()).getInstances() != null) {
                for (ReservationDescription.Instance instance : res.getInstances()) {
                    String state = String.valueOf(instance.getState()).toLowerCase();
                    String instanceId = instance.getInstanceId();
                    if (!state.equals("terminated")) {
                        if (!this.logger.isDebugEnabled()) continue;
                        this.logger.debug((Object)("Instance " + instanceId + " in state: " + state));
                        continue;
                    }
                    --count;
                    if (this.listener == null) continue;
                    this.listener.instanceDestroyed(instanceId);
                }
            }
        }
    }

    private HostNamePair getHostNamePair(ReservationDescription.Instance instance) {
        String internalHostName;
        String externalHostName = instance.getDnsName() != null ? instance.getDnsName().trim() : "";
        String string = internalHostName = instance.getPrivateDnsName() != null ? instance.getPrivateDnsName().trim() : "";
        if (externalHostName.length() == 0 || internalHostName.length() == 0) {
            return null;
        }
        return new HostNamePair(externalHostName, internalHostName);
    }
}

