/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils.impl;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import voldemort.utils.RemoteOperationException;
import voldemort.utils.RemoteTest;
import voldemort.utils.impl.CommandLineParameterizer;
import voldemort.utils.impl.CommandLineRemoteOperation;
import voldemort.utils.impl.ExitCodeCallable;
import voldemort.utils.impl.StdOutCommandOutputListener;
import voldemort.utils.impl.UnixCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SshRemoteTest
extends CommandLineRemoteOperation
implements RemoteTest {
    private final Collection<String> hostNames;
    private final File sshPrivateKey;
    private final String hostUserId;
    private final Map<String, String> commands;

    public SshRemoteTest(Collection<String> hostNames, File sshPrivateKey, String hostUserId, Map<String, String> commands) {
        this.hostNames = hostNames;
        this.sshPrivateKey = sshPrivateKey;
        this.hostUserId = hostUserId;
        this.commands = commands;
    }

    @Override
    public void execute() throws RemoteOperationException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"Executing remote tests");
        }
        CommandLineParameterizer commandLineParameterizer = new CommandLineParameterizer("SshRemoteTest.ssh" + (this.sshPrivateKey != null ? "" : ".nokey"));
        HashMap<String, String> hostNameCommandLineMap = new HashMap<String, String>();
        int index = 0;
        for (String hostName : this.hostNames) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("hostName", hostName);
            parameters.put("hostUserId", this.hostUserId);
            parameters.put("sshPrivateKey", this.sshPrivateKey != null ? this.sshPrivateKey.getAbsolutePath() : null);
            parameters.put("testCommand", this.commands.get(hostName));
            hostNameCommandLineMap.put(hostName, commandLineParameterizer.parameterize(parameters));
            ++index;
        }
        this.execute(hostNameCommandLineMap);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"Execution of remote tests complete");
        }
    }

    @Override
    protected Callable<?> getCallable(UnixCommand command) {
        StdOutCommandOutputListener commandOutputListener = new StdOutCommandOutputListener(null, true);
        return new ExitCodeCallable(command, commandOutputListener);
    }
}

