/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils.impl;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.Callable;
import voldemort.utils.ClusterStopper;
import voldemort.utils.RemoteOperationException;
import voldemort.utils.impl.CommandLineParameterizer;
import voldemort.utils.impl.CommandLineRemoteOperation;
import voldemort.utils.impl.LoggingCommandOutputListener;
import voldemort.utils.impl.UnixCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SshClusterStopper
extends CommandLineRemoteOperation
implements ClusterStopper {
    private final Collection<String> hostNames;
    private final File sshPrivateKey;
    private final String hostUserId;
    private final String voldemortRootDirectory;
    private final boolean suppressErrors;

    public SshClusterStopper(Collection<String> hostNames, File sshPrivateKey, String hostUserId, String voldemortRootDirectory, boolean suppressErrors) {
        this.hostNames = hostNames;
        this.sshPrivateKey = sshPrivateKey;
        this.hostUserId = hostUserId;
        this.voldemortRootDirectory = voldemortRootDirectory;
        this.suppressErrors = suppressErrors;
    }

    @Override
    public void execute() throws RemoteOperationException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"Stopping Voldemort cluster");
        }
        CommandLineParameterizer commandLineParameterizer = new CommandLineParameterizer("SshClusterStopper.ssh" + (this.sshPrivateKey != null ? "" : ".nokey"));
        HashMap<String, String> hostNameCommandLineMap = new HashMap<String, String>();
        for (String hostName : this.hostNames) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("hostName", hostName);
            parameters.put("hostUserId", this.hostUserId);
            parameters.put("sshPrivateKey", this.sshPrivateKey != null ? this.sshPrivateKey.getAbsolutePath() : null);
            parameters.put("voldemortRootDirectory", this.voldemortRootDirectory);
            hostNameCommandLineMap.put(hostName, commandLineParameterizer.parameterize(parameters));
        }
        this.execute(hostNameCommandLineMap);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"Stopping of Voldemort cluster complete");
        }
    }

    @Override
    protected Callable<?> getCallable(final UnixCommand command) {
        if (this.suppressErrors) {
            final LoggingCommandOutputListener commandOutputListener = new LoggingCommandOutputListener(null, this.logger, true);
            return new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    try {
                        command.execute(commandOutputListener);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                }
            };
        }
        return super.getCallable(command);
    }
}

