/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils.impl;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import voldemort.utils.ClusterCleaner;
import voldemort.utils.RemoteOperationException;
import voldemort.utils.impl.CommandLineParameterizer;
import voldemort.utils.impl.CommandLineRemoteOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SshClusterCleaner
extends CommandLineRemoteOperation
implements ClusterCleaner {
    private final Collection<String> hostNames;
    private final File sshPrivateKey;
    private final String hostUserId;
    private final String voldemortHomeDirectory;

    public SshClusterCleaner(Collection<String> hostNames, File sshPrivateKey, String hostUserId, String voldemortHomeDirectory) {
        this.hostNames = hostNames;
        this.sshPrivateKey = sshPrivateKey;
        this.hostUserId = hostUserId;
        this.voldemortHomeDirectory = voldemortHomeDirectory;
    }

    @Override
    public void execute() throws RemoteOperationException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Cleaning " + this.voldemortHomeDirectory + " on remote hosts: " + this.hostNames));
        }
        CommandLineParameterizer commandLineParameterizer = new CommandLineParameterizer("SshClusterCleaner.ssh" + (this.sshPrivateKey != null ? "" : ".nokey"));
        HashMap<String, String> hostNameCommandLineMap = new HashMap<String, String>();
        for (String hostName : this.hostNames) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("hostName", hostName);
            parameters.put("hostUserId", this.hostUserId);
            parameters.put("sshPrivateKey", this.sshPrivateKey != null ? this.sshPrivateKey.getAbsolutePath() : null);
            parameters.put("voldemortHomeDirectory", this.voldemortHomeDirectory);
            hostNameCommandLineMap.put(hostName, commandLineParameterizer.parameterize(parameters));
        }
        this.execute(hostNameCommandLineMap);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"Cleaning remote hosts complete");
        }
    }
}

