/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils.impl;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.Callable;
import voldemort.utils.Deployer;
import voldemort.utils.RemoteOperationException;
import voldemort.utils.impl.CommandLineParameterizer;
import voldemort.utils.impl.CommandLineRemoteOperation;
import voldemort.utils.impl.ExitCodeCallable;
import voldemort.utils.impl.LoggingCommandOutputListener;
import voldemort.utils.impl.UnixCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RsyncDeployer
extends CommandLineRemoteOperation
implements Deployer {
    private final Collection<String> hostNames;
    private final File sshPrivateKey;
    private final String hostUserId;
    private final File sourceDirectory;
    private final String destinationDirectory;

    public RsyncDeployer(Collection<String> hostNames, File sshPrivateKey, String hostUserId, File sourceDirectory, String destinationDirectory) {
        this.hostNames = hostNames;
        this.sshPrivateKey = sshPrivateKey;
        this.hostUserId = hostUserId;
        this.sourceDirectory = sourceDirectory;
        this.destinationDirectory = destinationDirectory;
    }

    @Override
    public void execute() throws RemoteOperationException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Rsync-ing " + this.sourceDirectory.getAbsolutePath() + " to " + this.destinationDirectory + " on remote hosts: " + this.hostNames));
        }
        if (!this.sourceDirectory.exists()) {
            throw new RemoteOperationException(this.sourceDirectory.getAbsolutePath() + " does not exist");
        }
        if (!this.sourceDirectory.isDirectory()) {
            throw new RemoteOperationException("Directory " + this.sourceDirectory.getAbsolutePath() + " is not a directory");
        }
        CommandLineParameterizer commandLineParameterizer = new CommandLineParameterizer("RsyncDeployer.rsync" + (this.sshPrivateKey != null ? "" : ".nokey"));
        HashMap<String, String> hostNameCommandLineMap = new HashMap<String, String>();
        for (String hostName : this.hostNames) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("hostName", hostName);
            parameters.put("hostUserId", this.hostUserId);
            parameters.put("sshPrivateKey", this.sshPrivateKey != null ? this.sshPrivateKey.getAbsolutePath() : null);
            parameters.put("destinationDirectory", this.destinationDirectory);
            parameters.put("sourceDirectory", this.sourceDirectory.getAbsolutePath());
            hostNameCommandLineMap.put(hostName, commandLineParameterizer.parameterize(parameters));
        }
        this.execute(hostNameCommandLineMap);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"Rsync-ing complete");
        }
    }

    @Override
    protected Callable<?> getCallable(UnixCommand command) {
        LoggingCommandOutputListener commandOutputListener = new LoggingCommandOutputListener(null, this.logger, false);
        return new ExitCodeCallable(command, commandOutputListener);
    }
}

