/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils.impl;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineParameterizer {
    public static final String HOST_NAME_PARAM = "hostName";
    public static final String HOST_USER_ID_PARAM = "hostUserId";
    public static final String SSH_PRIVATE_KEY_PARAM = "sshPrivateKey";
    public static final String VOLDEMORT_ROOT_DIRECTORY_PARAM = "voldemortRootDirectory";
    public static final String VOLDEMORT_HOME_DIRECTORY_PARAM = "voldemortHomeDirectory";
    public static final String VOLDEMORT_NODE_ID_PARAM = "voldemortNodeId";
    public static final String RAMP_TIME_PARAM = "rampTime";
    public static final String SOURCE_DIRECTORY_PARAM = "sourceDirectory";
    public static final String DESTINATION_DIRECTORY_PARAM = "destinationDirectory";
    public static final String TEST_COMMAND_PARAM = "testCommand";
    private final String rawCommand;

    public CommandLineParameterizer(String commandId) {
        Properties properties = new Properties();
        try {
            properties.load(this.getClass().getClassLoader().getResourceAsStream("commands.properties"));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this.rawCommand = properties.getProperty(commandId);
    }

    public String parameterize(Map<String, String> parameters) {
        String command = this.rawCommand;
        for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            command = StringUtils.replace((String)command, (String)("${" + parameter.getKey() + "}"), (String)parameter.getValue());
        }
        return command;
    }
}

