/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils.app;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import joptsimple.OptionSet;
import voldemort.utils.CmdUtils;
import voldemort.utils.HostNamePair;
import voldemort.utils.app.VoldemortApp;
import voldemort.utils.impl.RsyncDeployer;

public class VoldemortDeployerApp
extends VoldemortApp {
    public static void main(String[] args) throws Exception {
        new VoldemortDeployerApp().run(args);
    }

    protected String getScriptName() {
        return "voldemort-deployer.sh";
    }

    public void run(String[] args) throws Exception {
        this.parser.accepts("help", "Prints this help");
        this.parser.accepts("logging", "Options are \"debug\", \"info\" (default), \"warn\", \"error\", or \"off\"").withRequiredArg();
        this.parser.accepts("hostnames", "File containing host names").withRequiredArg();
        this.parser.accepts("sshprivatekey", "File containing SSH private key (optional)").withRequiredArg();
        this.parser.accepts("hostuserid", "User ID on remote host").withRequiredArg();
        this.parser.accepts("parent", "Parent directory on remote host").withRequiredArg();
        this.parser.accepts("source", "The source directory on the local machine").withRequiredArg();
        OptionSet options = this.parse(args);
        File hostNamesFile = this.getRequiredInputFile(options, "hostnames");
        File sshPrivateKey = this.getInputFile(options, "sshprivatekey");
        String hostUserId = (String)CmdUtils.valueOf((OptionSet)options, (String)"hostuserid", (Object)"root");
        File sourceDirectory = this.getRequiredInputFile(options, "source");
        String parentDirectory = this.getRequiredString(options, "parent");
        List<HostNamePair> hostNamePairs = this.getHostNamesPairsFromFile(hostNamesFile);
        ArrayList<String> hostNames = new ArrayList<String>();
        for (HostNamePair hostNamePair : hostNamePairs) {
            hostNames.add(hostNamePair.getExternalHostName());
        }
        RsyncDeployer operation = new RsyncDeployer(hostNames, sshPrivateKey, hostUserId, sourceDirectory, parentDirectory);
        operation.execute();
    }
}

