/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils.app;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import joptsimple.OptionSet;
import voldemort.utils.CmdUtils;
import voldemort.utils.HostNamePair;
import voldemort.utils.app.VoldemortApp;
import voldemort.utils.impl.SshClusterStopper;

public class VoldemortClusterStopperApp
extends VoldemortApp {
    public static void main(String[] args) throws Exception {
        new VoldemortClusterStopperApp().run(args);
    }

    protected String getScriptName() {
        return "voldemort-clusterstopper.sh";
    }

    public void run(String[] args) throws Exception {
        this.parser.accepts("help", "Prints this help");
        this.parser.accepts("logging", "Options are \"debug\", \"info\" (default), \"warn\", \"error\", or \"off\"").withRequiredArg();
        this.parser.accepts("hostnames", "File containing host names").withRequiredArg();
        this.parser.accepts("sshprivatekey", "File containing SSH private key (optional)").withRequiredArg();
        this.parser.accepts("hostuserid", "User ID on remote host").withRequiredArg();
        this.parser.accepts("voldemortroot", "Voldemort's root directory on remote host").withRequiredArg();
        OptionSet options = this.parse(args);
        File hostNamesFile = this.getRequiredInputFile(options, "hostnames");
        List<HostNamePair> hostNamePairs = this.getHostNamesPairsFromFile(hostNamesFile);
        ArrayList<String> hostNames = new ArrayList<String>();
        for (HostNamePair hostNamePair : hostNamePairs) {
            hostNames.add(hostNamePair.getExternalHostName());
        }
        File sshPrivateKey = this.getInputFile(options, "sshprivatekey");
        String hostUserId = (String)CmdUtils.valueOf((OptionSet)options, (String)"hostuserid", (Object)"root");
        String voldemortRootDirectory = this.getRequiredString(options, "voldemortroot");
        SshClusterStopper operation = new SshClusterStopper(hostNames, sshPrivateKey, hostUserId, voldemortRootDirectory, false);
        operation.execute();
    }
}

