/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils.app;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import joptsimple.OptionSet;
import voldemort.utils.ClusterGenerator;
import voldemort.utils.CmdUtils;
import voldemort.utils.HostNamePair;
import voldemort.utils.app.VoldemortApp;

public class VoldemortClusterGeneratorApp
extends VoldemortApp {
    public static void main(String[] args) throws Exception {
        new VoldemortClusterGeneratorApp().run(args);
    }

    protected String getScriptName() {
        return "voldemort-clustergenerator.sh";
    }

    public void run(String[] args) throws Exception {
        this.parser.accepts("help", "Prints this help");
        this.parser.accepts("logging", "Options are \"debug\", \"info\" (default), \"warn\", \"error\", or \"off\"").withRequiredArg();
        this.parser.accepts("hostnames", "File containing host names").withRequiredArg();
        this.parser.accepts("partitions", "Number of partitions per cluster node").withRequiredArg().ofType(Integer.class);
        this.parser.accepts("clustername", "Cluster name; defaults to mycluster").withRequiredArg();
        OptionSet options = this.parse(args);
        File hostNamesFile = this.getRequiredInputFile(options, "hostnames");
        int partitions = this.getRequiredInt(options, "partitions");
        String clusterName = (String)CmdUtils.valueOf((OptionSet)options, (String)"clustername", (Object)"mycluster");
        List<HostNamePair> hostNamePairs = this.getHostNamesPairsFromFile(hostNamesFile);
        ArrayList<String> hostNames = new ArrayList<String>();
        for (HostNamePair hostNamePair : hostNamePairs) {
            hostNames.add(hostNamePair.getInternalHostName());
        }
        String clusterXml = new ClusterGenerator().createClusterDescriptor(clusterName, hostNames, partitions);
        System.out.print(clusterXml);
    }
}

