/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils.app;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import voldemort.utils.CmdUtils;
import voldemort.utils.HostNamePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VoldemortApp {
    protected final OptionParser parser = new OptionParser();

    protected abstract String getScriptName();

    protected abstract void run(String[] var1) throws Exception;

    protected void printUsage() {
        System.err.println("Usage: $VOLDEMORT_HOME/contrib/ec2-testing/bin/" + this.getScriptName());
        try {
            this.parser.printHelpOn((OutputStream)System.err);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.exit(1);
    }

    protected OptionSet parse(String[] args) {
        try {
            OptionSet options = this.parser.parse(args);
            if (options.has("help")) {
                this.printUsage();
            }
            this.setLogging(options);
            return options;
        }
        catch (OptionException e) {
            System.err.println(e.getMessage());
            this.printUsage();
            return null;
        }
    }

    protected void setLogging(OptionSet options) {
        String levelString = (String)CmdUtils.valueOf((OptionSet)options, (String)"logging", (Object)"info");
        Level level = null;
        if (levelString.equals("debug")) {
            level = Level.DEBUG;
        } else if (levelString.equals("info")) {
            level = Level.INFO;
        } else if (levelString.equals("warn")) {
            level = Level.WARN;
        } else if (levelString.equals("error")) {
            level = Level.ERROR;
        } else if (levelString.equals("off")) {
            level = Level.OFF;
        } else {
            this.printUsage();
        }
        Logger rootLogger = Logger.getRootLogger();
        rootLogger.setLevel(level);
        Enumeration e = rootLogger.getLoggerRepository().getCurrentLoggers();
        while (e.hasMoreElements()) {
            Logger logger = (Logger)e.nextElement();
            logger.setLevel(level);
        }
    }

    protected String getRequiredString(OptionSet options, String argumentName) {
        if (!options.has(argumentName)) {
            System.err.println("Missing required argument " + argumentName);
            this.printUsage();
        }
        return (String)CmdUtils.valueOf((OptionSet)options, (String)argumentName, (Object)"");
    }

    protected int getRequiredInt(OptionSet options, String argumentName) {
        if (!options.has(argumentName)) {
            System.err.println("Missing required argument " + argumentName);
            this.printUsage();
        }
        return (Integer)CmdUtils.valueOf((OptionSet)options, (String)argumentName, (Object)0);
    }

    protected long getRequiredLong(OptionSet options, String argumentName) {
        if (!options.has(argumentName)) {
            System.err.println("Missing required argument " + argumentName);
            this.printUsage();
        }
        return Long.parseLong((String)CmdUtils.valueOf((OptionSet)options, (String)argumentName, (Object)"0"));
    }

    protected File getRequiredInputFile(OptionSet options, String argumentName) {
        String fileName = this.getRequiredString(options, argumentName);
        File file = new File(fileName);
        if (!file.canRead()) {
            System.err.println("File " + fileName + " cannot be read");
            System.exit(2);
        }
        return file;
    }

    protected File getInputFile(OptionSet options, String argumentName) {
        if (!options.has(argumentName)) {
            return null;
        }
        String fileName = (String)CmdUtils.valueOf((OptionSet)options, (String)argumentName, (Object)"");
        File file = new File(fileName);
        if (!file.canRead()) {
            System.err.println("File " + fileName + " cannot be read");
            System.exit(2);
        }
        return file;
    }

    protected List<HostNamePair> getHostNamesPairsFromFile(File file) {
        Map<String, String> properties = this.getRequiredPropertiesFile(file);
        ArrayList<HostNamePair> hostNamePairs = new ArrayList<HostNamePair>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String externalHostName = entry.getKey();
            String internalHostName = entry.getValue() != null ? entry.getValue() : externalHostName;
            hostNamePairs.add(new HostNamePair(externalHostName, internalHostName));
        }
        return hostNamePairs;
    }

    protected Map<String, String> getRequiredPropertiesFile(File file) {
        if (!file.canRead()) {
            System.err.println("File " + file.getAbsolutePath() + " cannot be read");
            System.exit(2);
        }
        Properties properties = new Properties();
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            properties.load(is);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = entry.getKey() != null ? entry.getKey().toString() : null;
            String value = entry.getValue() != null ? entry.getValue().toString() : null;
            map.put(key, value);
        }
        return map;
    }

    protected String getAccessId(OptionSet options) throws Exception {
        if (!options.has("accessid") && !options.has("accessidfile")) {
            System.err.println("Missing required argument accessid or accessidfile");
            this.printUsage();
        } else if (options.has("accessid") && options.has("accessidfile")) {
            System.err.println("Provide either accessid or accessidfile, not both");
            this.printUsage();
        } else {
            if (options.has("accessid")) {
                return (String)CmdUtils.valueOf((OptionSet)options, (String)"accessid", (Object)"");
            }
            File file = new File((String)CmdUtils.valueOf((OptionSet)options, (String)"accessidfile", (Object)""));
            return FileUtils.readFileToString((File)file).trim();
        }
        return null;
    }

    protected String getSecretKey(OptionSet options) throws Exception {
        if (!options.has("secretkey") && !options.has("secretkeyfile")) {
            System.err.println("Missing required argument secretkey or secretkeyfile");
            this.printUsage();
        } else if (options.has("secretkey") && options.has("secretkeyfile")) {
            System.err.println("Provide either secretkey or secretkeyfile, not both");
            this.printUsage();
        } else {
            if (options.has("secretkey")) {
                return (String)CmdUtils.valueOf((OptionSet)options, (String)"secretkey", (Object)"");
            }
            File file = new File((String)CmdUtils.valueOf((OptionSet)options, (String)"secretkeyfile", (Object)""));
            return FileUtils.readFileToString((File)file).trim();
        }
        return null;
    }
}

