/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import voldemort.cluster.Cluster;
import voldemort.utils.ClusterGenerator;
import voldemort.utils.ClusterNodeDescriptor;
import voldemort.utils.HostNamePair;
import voldemort.utils.RemoteOperationException;
import voldemort.utils.RemoteTestConfig;
import voldemort.utils.impl.RsyncDeployer;
import voldemort.utils.impl.SshClusterCleaner;
import voldemort.utils.impl.SshClusterStarter;
import voldemort.utils.impl.SshClusterStopper;
import voldemort.utils.impl.SshRemoteTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteTestUtils {
    private static final Logger logger = Logger.getLogger(RemoteTestUtils.class);

    public static void deploy(List<String> hostNames, RemoteTestConfig remoteTestConfig) throws Exception {
        new RsyncDeployer(hostNames, remoteTestConfig.getSshPrivateKey(), remoteTestConfig.getHostUserId(), remoteTestConfig.getSourceDirectory(), remoteTestConfig.getParentDirectory()).execute();
    }

    public static void executeRemoteTest(List<String> hostNames, RemoteTestConfig remoteTestConfig, Map<String, String> commands) throws Exception {
        new SshRemoteTest(hostNames, remoteTestConfig.getSshPrivateKey(), remoteTestConfig.getHostUserId(), commands).execute();
    }

    public static void startClusterAsync(List<String> hostNames, RemoteTestConfig remoteTestConfig, Map<String, Integer> nodeIds) throws Exception {
        RemoteTestUtils.startCluster(hostNames, remoteTestConfig, nodeIds, true, 10);
    }

    public static void startCluster(final List<String> hostNames, final RemoteTestConfig remoteTestConfig, final Map<String, Integer> nodeIds, boolean startAsynchronously, int waitSeconds) throws Exception {
        if (startAsynchronously) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        new SshClusterStarter(hostNames, remoteTestConfig.getSshPrivateKey(), remoteTestConfig.getHostUserId(), remoteTestConfig.getVoldemortRootDirectory(), remoteTestConfig.getVoldemortHomeDirectory(), nodeIds).execute();
                    }
                    catch (RemoteOperationException e) {
                        e.printStackTrace();
                    }
                }
            }).start();
            Thread.sleep(waitSeconds * 1000);
        } else {
            new SshClusterStarter(hostNames, remoteTestConfig.getSshPrivateKey(), remoteTestConfig.getHostUserId(), remoteTestConfig.getVoldemortRootDirectory(), remoteTestConfig.getVoldemortHomeDirectory(), nodeIds).execute();
        }
    }

    public static void startClusterNode(String hostName, RemoteTestConfig remoteTestConfig, int nodeId) throws Exception {
        HashMap<String, Integer> nodeIds = new HashMap<String, Integer>();
        nodeIds.put(hostName, nodeId);
        RemoteTestUtils.startClusterAsync(new ArrayList<String>(Arrays.asList(hostName)), remoteTestConfig, nodeIds);
    }

    public static void cleanupCluster(List<String> hostNames, RemoteTestConfig remoteTestConfig) throws Exception {
        new SshClusterCleaner(hostNames, remoteTestConfig.getSshPrivateKey(), remoteTestConfig.getHostUserId(), remoteTestConfig.getVoldemortHomeDirectory()).execute();
    }

    public static void stopCluster(List<String> hostNames, RemoteTestConfig remoteTestConfig) throws Exception {
        new SshClusterStopper(hostNames, remoteTestConfig.getSshPrivateKey(), remoteTestConfig.getHostUserId(), remoteTestConfig.getVoldemortRootDirectory(), false).execute();
    }

    public static void stopClusterQuiet(List<String> hostNames, RemoteTestConfig remoteTestConfig) throws Exception {
        block2: {
            try {
                new SshClusterStopper(hostNames, remoteTestConfig.getSshPrivateKey(), remoteTestConfig.getHostUserId(), remoteTestConfig.getVoldemortRootDirectory(), true).execute();
            }
            catch (Exception e) {
                if (!logger.isEnabledFor((Priority)Level.WARN)) break block2;
                logger.warn((Object)e, (Throwable)e);
            }
        }
    }

    public static void stopClusterNode(String hostName, RemoteTestConfig remoteTestConfig) throws Exception {
        RemoteTestUtils.stopCluster(Arrays.asList(hostName), remoteTestConfig);
    }

    public static List<String> toHostNames(List<HostNamePair> hostNamePairs) {
        ArrayList<String> hostNames = new ArrayList<String>();
        for (HostNamePair hostNamePair : hostNamePairs) {
            hostNames.add(hostNamePair.getExternalHostName());
        }
        return hostNames;
    }

    public static Map<String, Integer> generateClusterDescriptor(List<HostNamePair> hostNamePairs, String clusterName, RemoteTestConfig remoteTestConfig) throws Exception {
        return RemoteTestUtils.generateClusterDescriptor(hostNamePairs, clusterName, remoteTestConfig, false);
    }

    public static Map<String, Integer> generateClusterDescriptor(List<HostNamePair> hostNamePairs, String clusterName, RemoteTestConfig remoteTestConfig, boolean useExternal) throws Exception {
        ArrayList<String> hostNames = new ArrayList<String>();
        for (HostNamePair hostNamePair : hostNamePairs) {
            hostNames.add(useExternal ? hostNamePair.getExternalHostName() : hostNamePair.getInternalHostName());
        }
        ClusterGenerator clusterGenerator = new ClusterGenerator();
        List<ClusterNodeDescriptor> nodes = clusterGenerator.createClusterNodeDescriptors(hostNames, 3);
        String clusterXml = clusterGenerator.createClusterDescriptor(clusterName, nodes);
        FileUtils.writeStringToFile((File)remoteTestConfig.getClusterXmlFile(), (String)clusterXml);
        HashMap<String, Integer> nodeIds = new HashMap<String, Integer>();
        for (ClusterNodeDescriptor node : nodes) {
            if (useExternal) {
                nodeIds.put(node.getHostName(), node.getId());
                continue;
            }
            for (HostNamePair hostNamePair : hostNamePairs) {
                if (!node.getHostName().equals(hostNamePair.getInternalHostName())) continue;
                nodeIds.put(hostNamePair.getExternalHostName(), node.getId());
            }
        }
        return nodeIds;
    }

    public static Map<String, Integer> generateClusterDescriptor(List<HostNamePair> hostNamePairs, Cluster cluster, RemoteTestConfig remoteTestConfig) throws Exception {
        ArrayList<String> hostNames = new ArrayList<String>();
        for (HostNamePair hostNamePair : hostNamePairs) {
            hostNames.add(hostNamePair.getExternalHostName());
        }
        ClusterGenerator clusterGenerator = new ClusterGenerator();
        List<ClusterNodeDescriptor> nodes = clusterGenerator.createClusterNodeDescriptors(hostNames, cluster);
        String clusterXml = clusterGenerator.createClusterDescriptor(cluster.getName(), nodes);
        FileUtils.writeStringToFile((File)remoteTestConfig.getClusterXmlFile(), (String)clusterXml);
        HashMap<String, Integer> nodeIds = new HashMap<String, Integer>();
        for (ClusterNodeDescriptor node : nodes) {
            nodeIds.put(node.getHostName(), node.getId());
        }
        return nodeIds;
    }
}

